% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NPEint}
\alias{NPEint}
\title{The end points of the Proportional Edge (PE) Proximity Region for a point - one interval case}
\usage{
NPEint(x, r, c = 0.5, int)
}
\arguments{
\item{x}{A 1D point for which PE proximity region is constructed.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}, and default=\code{0.5}}

\item{int}{A \code{vector} of two real numbers representing an interval.}
}
\value{
The interval which constitutes the PE proximity region for the point \code{x}
}
\description{
Returns the end points of the interval which constitutes the PE proximity region for a point in the
interval \code{int}\eqn{=(a,b)=}\code{(rv=1,rv=2)}. PE proximity region is constructed with respect to the interval \code{int}
with expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)}.

Vertex regions are based on the (parameterized) center, \eqn{M_c},
which is \eqn{M_c=a+c(b-a)} for the interval, \code{int}\eqn{=(a,b)}.
The PE proximity region is constructed whether \code{x} is inside or outside the interval \code{int}.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

NPEint(7,r,c,int)
NPEint(17,r,c,int)
NPEint(1,r,c,int)
NPEint(-1,r,c,int)

NPEint(3,r,c,int)
NPEint(4,r,c,int)
NPEint(a,r,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NCSint}}, \code{\link{NPEtri}} and \code{\link{NPEtetra}}
}
\author{
Elvan Ceyhan
}
