% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam2PEtetra}
\alias{Gam2PEtetra}
\title{The indicator for two 3D points constituting a dominating set for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - one tetrahedron case}
\usage{
Gam2PEtetra(
  pt1,
  pt2,
  Dt,
  r,
  th,
  M = "CM",
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{pt1, pt2}{Two 3D points to be tested for constituting a dominating set of the PE-PCD.}

\item{Dt}{A set of 3D points which constitutes the vertices of the PE-PCD.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{th}{Four 3D points, stacked row-wise, each row representing a vertex of the tetrahedron.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{pt1} and \code{pt2}, respectively.
They take the vertex labels as \code{1,2,3,4} as in the row order of the vertices in \code{th}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for checking whether both points \code{pt1} and \code{pt2} are
data points in \code{Dt} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{pt1,pt2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 3D data set \code{Dt}),
that is, returns 1 if \{\code{pt1,pt2}\} is a dominating set of PE-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{pt1,pt2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 3D data set \code{Dt} in the tetrahedron \code{th}, that is,
returns 1 if \{\code{pt1,pt2}\} is a dominating set of PE-PCD, returns 0 otherwise.

Point, \code{pt1}, is in the region of vertex \code{rv1} (default is \code{NULL}) and point, \code{pt2}, is in the region of vertex \code{rv2}
(default is \code{NULL}); vertices (and hence \code{rv1} and \code{rv2}) are labeled as \code{1,2,3,4} in the order they are stacked
row-wise in \code{th}.

PE proximity region is constructed with respect to the tetrahedron \code{th} with expansion parameter \eqn{r \ge 1}
and vertex regions are based on center of mass (\code{M="CM"}) or circumcenter (\code{M="CC"}) only.

\code{ch.data.pnts} is for checking whether points \code{pt1} and \code{pt2} are both data points in \code{Dt} or not (default is \code{FALSE}),
so by default this function checks whether the points \code{pt1} and \code{pt2} would constitute a dominating set
if they actually were both in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-20

dat<-runif.tetra(n,tetra)$g  #try also dat<-cbind(runif(n),runif(n),runif(n))

M<-"CM";  #try also M<-"CC";
r<-1.5

Gam2PEtetra(dat[1,],dat[2,],dat,r,tetra,M)
Gam2PEtetra(dat[1,],dat[1,],dat,r,tetra,M)

Gam2PEtetra(c(-1,-1,-1),dat[2,],dat,r,tetra,M)

Gam2PEtetra(c(-1,-1,-1),c(-1,-1,-2),rbind(c(-1,-1,-1),c(-1,-1,-2)),r,tetra,M)

ind.gam2<-ind.gamn2<-vector()
for (i in 1:(n-1))
 for (j in (i+1):n)
 {if (Gam2PEtetra(dat[i,],dat[j,],dat,r,tetra,M)==1)
 {ind.gam2<-rbind(ind.gam2,c(i,j))
 }
 }
ind.gam2

#or try
rv1<-rv.tetraCC(dat[1,],tetra)$rv;rv2<-rv.tetraCC(dat[2,],tetra)$rv
Gam2PEtetra(dat[1,],dat[2,],dat,r,tetra,M,rv1,rv2)

#or try
rv1<-rv.tetraCC(dat[1,],tetra)$rv;
Gam2PEtetra(dat[1,],dat[2,],dat,r,tetra,M,rv1)

#or try
rv2<-rv.tetraCC(dat[2,],tetra)$rv
Gam2PEtetra(dat[1,],dat[2,],dat,r,tetra,M,rv2=rv2)

P1<-c(.1,.1,.1)
P2<-c(.4,.1,.2)
Gam2PEtetra(P1,P2,dat,r,tetra,M)

dat.fr<-data.frame(a=dat)
Gam2PEtetra(P1,P2,dat.fr,r,tetra,M)

Gam2PEtetra(c(-1,-1,-1),dat[2,],dat,r,tetra,M,ch.data.pnts = FALSE)
#gives an error message if ch.data.pnts = TRUE
#since not both points, pt1 and pt2, are data points in Dt

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam2PEstdTetra}}, \code{\link{Gam2PEtri}} and \code{\link{Gam2PEbastri}}
}
\author{
Elvan Ceyhan
}
