% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rasc.disc}
\alias{rasc.disc}
\title{Generation of points associated (in a radial or circular fashion) with a given set of points}
\usage{
rasc.disc(
  n,
  Y,
  e,
  a1 = min(Y[, 1]),
  a2 = max(Y[, 1]),
  b1 = min(Y[, 2]),
  b2 = max(Y[, 2])
)
}
\arguments{
\item{n}{A positive integer representing the number of points to be generated.}

\item{Y}{A set of 2D points representing the reference points. The generated points are associated
(in a circular/radial fashion) with these points.}

\item{e}{A positive real number representing the radius of the balls centered at \code{Y} points. Only these
balls are allowed for the generated points (i.e., generated points would be in the union of these balls).}

\item{a1, a2}{Real numbers representing the range of x-coordinates in the region
(default is the range of x-coordinates of the \code{Y} points).}

\item{b1, b2}{Real numbers representing the range of y-coordinates in the region
(default is the range of y-coordinates of the \code{Y} points).}
}
\value{
A list with the elements
\item{type}{The type of the point pattern}
\item{mtitle}{The "main" title for the plot of the point pattern}
\item{parameters}{Radial attraction parameter of the association pattern}
\item{ref.points}{The input set of attraction points \code{Y},
i.e., points with which generated points are associated.}
\item{gen.points}{The output set of generated points associated with \code{Y} points}
\item{tri.Y}{Logical output for triangulation based on \code{Y} points should be implemented or not.
if \code{TRUE} triangulation based on \code{Y} points is to be implemented (default is set to \code{FALSE}).}
\item{desc.pat}{Description of the point pattern}
\item{num.points}{The vector of two numbers, which are the number of generated points and the number of
attraction (i.e., \code{Y}) points.}
\item{xlimit,ylimit}{The possible range of the x- and y-coordinates of the generated points.}
}
\description{
An object of class "Patterns".
Generates \code{n} 2D points uniformly in \eqn{(a1-e,a1+e)x(a1-e,a1+e) \cap U_i B(y_i,e)} where
\eqn{Y=(y_1,y_2,...,y_{n_y})} with
\eqn{n_y} being number of \code{Y} points for various values of e under the association pattern
and \eqn{B(y_i,e)} is the ball centered at \eqn{y_i} with radius \code{e}.

\code{e} must be positive and very large values of e provide patterns close to CSR.
\code{a1} is defaulted to the minimum of the x-coordinates of the \code{Y} points,
\code{a2} is defaulted to the maximum of the x-coordinates of the \code{Y} points,
\code{b1} is defaulted to the minimum of the y-coordinates of the \code{Y} points,
\code{b2} is defaulted to the maximum of the y-coordinates of the \code{Y} points.
This function is also very similar to \code{\link{rasc.matern}}, where \code{rasc.disc} needs the study window to be specified,
while \code{\link{rasc.matern}} does not.
}
\examples{
nx<-20; ny<-4;  #try also nx<-1000; ny<-10;

e<-.15;
#with default bounding box (i.e., unit square)
Y<-cbind(runif(ny),runif(ny))

Xdat<-rasc.disc(nx,Y,e)
Xdat
summary(Xdat)
plot(Xdat,asp=1)

Xdt<-rasc.disc(nx,Y,e)$gen.points
Xlim<-range(Xdt[,1],Y[,1]);
Ylim<-range(Xdt[,2],Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Y,asp=1,xlab="x",ylab="y",main="association of two classes",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01),pch=16,col=2,lwd=2)
points(Xdt)

e<-.25; #pattern is very close to CSR!
#try also e<-.1;

#with default bounding box (i.e., unit square)
Y<-cbind(runif(ny),runif(ny))
Xdt<-rasc.disc(nx,Y,e)$gen.points

Xlim<-range(Xdt[,1],Y[,1]);
Ylim<-range(Xdt[,2],Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Y,asp=1,xlab="x",ylab="y",main="association of two classes",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01),pch=16,col=2,lwd=2)
points(Xdt)

#with a rectangular bounding box
a1<-0; a2<-10;
b1<-0; b2<-5;
e<-1.1;  #try also e<-5; #pattern very close to CSR!

Y<-cbind(runif(ny,a1,a2),runif(ny,b1,b2))
#try also Y<-cbind(runif(ny,a1,a2/2),runif(ny,b1,b2/2))

Xdt<-rasc.disc(nx,Y,e,a1,a2,b1,b2)$gen.points
Xlim<-range(Xdt[,1],Y[,1]);
Ylim<-range(Xdt[,2],Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Y,asp=1,xlab="x",ylab="y",main="association of two classes",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01),pch=16,col=2,lwd=2)
points(Xdt)

e<-.15
Y<-data.frame(yp=cbind(runif(ny),runif(ny)) )
Xdt<-rasc.disc(nx,Y,e)

}
\seealso{
\code{\link{rseg.disc}}, \code{\link{rascTe}}, \code{\link{rascIITe}},
\code{\link{rasc.matern}}, and \code{\link{rascMT}}
}
