% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsPEtri}
\alias{NumArcsPEtri}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one triangle case}
\usage{
NumArcsPEtri(dat, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{dat}{A set of 2D points which constitute the vertices of PE-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.}
}
\value{
Number of arcs of the PE-PCD with vertices being 2D data set, \code{dat}, in \code{tri}
with expansion parameter, \eqn{r \ge 1}, and center \code{M}. PE proximity regions are defined only
for \code{dat} points inside \code{tri}, i.e. arcs are possible for such points only.
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) whose vertices are the
given 2D numerical data set, \code{dat}.

PE proximity region \eqn{NPE(x,r)} is defined with respect to the triangle, \code{tri}
for this function. PE proximity region is constructed with expansion parameter \eqn{r \ge 1} and vertex regions are
based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri} or based on circumcenter of \code{tri}; default is \eqn{M=(1,1,1)} i.e. the center
of mass of \code{tri}. For the number of arcs, loops are not
allowed so arcs are only possible for points inside the triangle \code{tri} for this function.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

n<-10  #try also n<-20
set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

NumArcsPEtri(dat,Tr,r=1.25,M)
NumArcsPEtri(dat,Tr,r=1.5,M)
NumArcsPEtri(dat,Tr,r=2.0,M)

NumArcsPEtri(rbind(dat,c(0,2)),Tr,r=1.25,M)

r<-2
NumArcsPEtri(dat,Tr,r,M)

dat.fr<-data.frame(a=dat)
NumArcsPEtri(dat.fr,Tr,r,M)

dat.fr<-data.frame(a=Tr)
NumArcsPEtri(dat,dat.fr,r,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPETe}}, \code{\link{NumArcsPEMT}}, \code{\link{NumArcsCStri}},
and \code{\link{NumArcsAStri}}
}
