% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsMuVarPE2D}
\alias{funsMuVarPE2D}
\alias{muPE2D}
\alias{asyvarPE2D}
\title{Two functions: \code{muPE2D} and \code{asyvarPE2D} ---

Returns the mean and (asymptotic) variance of arc density of Proportional Edge Proximity Catch Digraph (PE-PCD)
for 2D uniform data in one triangle}
\usage{
muPE2D(r)

asyvarPE2D(r)
}
\arguments{
\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}
}
\value{
\code{muPE2D} returns the mean and \code{asyvarPE2D} returns the (asymptotic) variance of the
arc density of PE-PCD for uniform data in any triangle
}
\description{
\code{muPE2D} returns the mean of the (arc) density of PE-PCD
and \code{asyvarPE2D} returns the asymptotic variance of the arc density of PE-PCD
with expansion parameter \eqn{r \ge 1} for 2D uniform data in a triangle.

PE proximity regions are defined with respect to the triangle and
vertex regions are based on center of mass, CM of the triangle.

See also (\insertCite{ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
#Examples for muPE2D
muPE2D(1.2)

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

mu<-vector()
for (i in 1:lrseq)
{
  mu<-c(mu,muPE2D(rseq[i]))
}

plot(rseq, mu,type="l",xlab="r",ylab=expression(mu(r)),lty=1,xlim=range(rseq),ylim=c(0,1))

#Examples for asyvarPE2D
asyvarPE2D(1.2)

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

avar<-vector()
for (i in 1:lrseq)
{
  avar<-c(avar,asyvarPE2D(rseq[i]))
}

oldpar <- par(mfrow = c(1,2))
par(mar=c(5,5,4,2))
plot(rseq, avar,type="l",xlab="r",ylab=expression(paste(sigma^2,"(r)")),lty=1,xlim=range(rseq))
par(oldpar)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{muCS2D}} and \code{\link{asyvarCS2D}}
}
