% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{dom.greedy}
\alias{dom.greedy}
\title{Approximate domination number and approximate dominating set by the greedy algorithm}
\usage{
dom.greedy(Inc.Mat)
}
\arguments{
\item{Inc.Mat}{A square matrix consisting of 0s and 1s which represents the incidence matrix of
a graph or digraph}
}
\value{
A list with two elements
\item{dom.num}{The cardinality of the (approximate) minimum dominating set found by the greedy algorithm.
i.e. (approximate) domination number of the graph or digraph whose incidence matrix \code{Inc.Mat} is given
as input.}
\item{ind.domset}{Indices of the rows in the incidence matrix \code{Inc.Mat} for the ((approximate) minimum
dominating set). The row numbers in the incidence matrix correspond to the indices of the vertices
(i.e. indices of the data points).}
}
\description{
Returns the (approximate) domination number and the indices (i.e. row numbers) for the corresponding
(approximate) minimum dominating set based on the incidence matrix \code{Inc.Mat} of a graph or a digraph
by using the greedy algorithm (\insertCite{chvatal:1979;textual}{pcds}).
Here the row number in the incidence matrix corresponds to the index of the vertex (i.e. index of the
data point). The function works whether loops are allowed or not (i.e., whether the first diagonal
is all 1 or all 0). This function may yield the actual domination number or overestimates it.
}
\examples{
n<-10
M<-matrix(sample(c(0,1),n^2,replace=TRUE),nrow=n)
diag(M)<-1

dom.greedy(M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{dom.exact}}, \code{\link{PEdom1D}}, \code{\link{PEdomtri}}, \code{\link{PEdomMTnd}},
and \code{\link{IndCSdomUBtri}}
}
