\name{gmG}
\title{Graphical Model 8-Dimensional Gaussian Example Data}
\alias{gmG}
\alias{gmG8}
\docType{data}
\description{
  These two data sets contain a matrix containing information on eight gaussian
  variables and the corresonding DAG model.
}
\usage{data(gmG)}
\format{
  \code{gmG} and \code{gmG8} are each a \code{\link{list}} of two components
  \describe{
    \item{x:}{a numeric matrix \eqn{5000 \times 8}{5000 * 8}.}
    \item{g:}{a graph, i.e., of formal \code{\link{class}}
      \code{"graphNEL"} from package \pkg{graph} with 6 slots\cr
      .. ..@ nodes     : chr [1:8] "1" "2" "3" "4" ...\cr
      .. ..@ edgeL     :List of 8\cr
      ........
    }
  }
}
\details{
  The data was generated as indicated below.  First, a random DAG model was
  generated, then 5000 samples were drawn from \dQuote{almost} this
  model, for \code{gmG}:  In the previous version, the data generation
  \code{\link{wgtMatrix}} had the non-zero weights in reversed order for
  each node.  On the other hand, for \code{gmG8}, the correct weights
  were used in all cases
}
\source{
  The data set is \code{\link{identical}} to the one generated by
 \preformatted{%%--> ../tests/test_rmvDAG.R  now tests this:
    ## Used to generate "gmG"
    set.seed(40)
    p <- 8
    n <- 5000
    ## true DAG:
    vars <- c("Author", "Bar", "Ctrl", "Goal", paste0("V",5:8))
    gGtrue <- randomDAG(p, prob = 0.3, V = vars)
    gmG  <- list(x = rmvDAG(n, gGtrue, back.compatible=TRUE), g = gGtrue)
    gmG8 <- list(x = rmvDAG(n, gGtrue),                       g = gGtrue)
  }
}
\examples{
data(gmG)
str(gmG, max=3)
stopifnot(identical(gmG $ g, gmG8 $ g))
if(dev.interactive()) { ## to save time in tests
  round(as(gmG $ g, "Matrix"), 2) # weight ("adjacency") matrix
  plot(gmG $ g)
  pairs(gmG$x, gap = 0,
	panel=function(...) smoothScatter(..., add=TRUE))
}
}
\keyword{datasets}
