% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.r
\docType{methods}
\name{as.matrix}
\alias{as.matrix}
\alias{as.matrix,ddmatrix-method}
\title{Distributed object to Matrix Converters}
\usage{
\S4method{as.matrix}{ddmatrix}(x, proc.dest = "all", attributes = TRUE)
}
\arguments{
\item{x}{numeric distributed matrix}

\item{proc.dest}{destination process for storing the matrix}

\item{attributes}{logical, specifies whether or not the current attributes
should be preserved.}

\item{...}{Additional arguments.}
}
\value{
Returns an ordinary R matrix.
}
\description{
Converts a distributed matrix into a non-distributed matrix.
}
\details{
The \code{proc.dest=} argument accepts either the BLACS grid position or the
MPI rank if the user desires a single process to own the matrix.
Alternatively, passing the default value of \code{'all'} will result in all
processes owning the matrix. If only a single process owns the undistributed
matrix, then all other processes store \code{NULL} for that object.
}
\examples{
spmd.code = "
  library(pbdDMAT, quiet = TRUE)
  init.grid()
  
  dx <- ddmatrix(1:16, ncol=4, bldim=2)
  y <- as.matrix(dx, proc.dest=0)
  
  comm.print(y)
  
  finalize()
"

pbdMPI::execmpi(spmd.code = spmd.code, nranks = 2L)

}
\keyword{Methods}
