% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_bind.r
\docType{methods}
\name{binds}
\alias{binds}
\alias{cbind,ANY-method}
\alias{rbind,ANY-method}
\title{Row and Column binds for Distributed Matrices}
\usage{
\S4method{rbind}{ANY}(..., ICTXT = .pbd_env$ICTXT, deparse.level = 1)

\S4method{cbind}{ANY}(..., ICTXT = .pbd_env$ICTXT, deparse.level = 1)
}
\arguments{
\item{...}{vectors, matrices, or distributed matrices.}

\item{ICTXT}{BLACS communicator number for return object.}

\item{deparse.level}{integer controlling the construction of labels in the
case of non-matrix-like arguments. Does nothing for distributed matrices.}
}
\value{
Returns a vector, matrix, or distributed matrix, depending on input.
}
\description{
Row and column binds.
}
\details{
The \code{...} list of arguments can be vectors, matrices, or distributed
matrices so long as non-distributed objects are not used with distributed
objects. This kind of mixing-and-matching will lead to chaos. Currently no
check is performed to prevent the user from this mixing-and-matching for
performance reasons (it is slow enough already).
}
\section{Methods}{
 \describe{ \item{list("signature(... = \"ANY\")")}{an R
object.} }
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix(1:16, ncol=4, bldim=2)

y <- rbind(x, x)

print(y)

finalize()
}

}
\keyword{Methods}

