% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{sso}
\alias{sso}
\title{AWS Single Sign-On}
\usage{
sso(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
AWS IAM Identity Center (successor to AWS Single Sign-On) Portal is a
web service that makes it easy for you to assign user access to IAM
Identity Center resources such as the AWS access portal. Users can get
AWS account applications and roles assigned to them and get federated
into the application.

Although AWS Single Sign-On was renamed, the \code{sso} and \code{identitystore}
API namespaces will continue to retain their original name for backward
compatibility purposes. For more information, see \href{https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed}{IAM Identity Center rename}.

This reference guide describes the IAM Identity Center Portal operations
that you can call programatically and includes detailed information on
data types and errors.

AWS provides SDKs that consist of libraries and sample code for various
programming languages and platforms, such as Java, Ruby, .Net, iOS, or
Android. The SDKs provide a convenient way to create programmatic access
to IAM Identity Center and other AWS services. For more information
about the AWS SDKs, including how to download and install them, see
\href{https://aws.amazon.com/developer/tools/}{Tools for Amazon Web Services}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- sso(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:sso_get_role_credentials]{get_role_credentials} \tab Returns the STS short-term credentials for a given role name that is assigned to the user\cr
\link[paws.security.identity:sso_list_account_roles]{list_account_roles} \tab Lists all roles that are assigned to the user for a given AWS account\cr
\link[paws.security.identity:sso_list_accounts]{list_accounts} \tab Lists all AWS accounts assigned to the user\cr
\link[paws.security.identity:sso_logout]{logout} \tab Removes the locally stored SSO tokens from the client-side cache and sends an API call to the IAM Identity Center service to invalidate the corresponding server-side IAM Identity Center sign in session
}
}

\examples{
\dontrun{
svc <- sso()
svc$get_role_credentials(
  Foo = 123
)
}

}
