% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{cloudtrail}
\alias{cloudtrail}
\title{AWS CloudTrail}
\usage{
cloudtrail(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
CloudTrail

This is the CloudTrail API Reference. It provides descriptions of
actions, data types, common parameters, and common errors for
CloudTrail.

CloudTrail is a web service that records Amazon Web Services API calls
for your Amazon Web Services account and delivers log files to an Amazon
S3 bucket. The recorded information includes the identity of the user,
the start time of the Amazon Web Services API call, the source IP
address, the request parameters, and the response elements returned by
the service.

As an alternative to the API, you can use one of the Amazon Web Services
SDKs, which consist of libraries and sample code for various programming
languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs
provide programmatic access to CloudTrail. For example, the SDKs handle
cryptographically signing requests, managing errors, and retrying
requests automatically. For more information about the Amazon Web
Services SDKs, including how to download and install them, see \href{https://aws.amazon.com/developer/tools/}{Tools to Build on Amazon Web Services}.

See the \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html}{CloudTrail User Guide}
for information about the data that is included with each Amazon Web
Services API call listed in the log files.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- cloudtrail(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:cloudtrail_add_tags]{add_tags} \tab Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50\cr
\link[paws.management:cloudtrail_cancel_query]{cancel_query} \tab Cancels a query if the query is not in a terminated state, such as CANCELLED, FAILED, TIMED_OUT, or FINISHED\cr
\link[paws.management:cloudtrail_create_channel]{create_channel} \tab Creates a channel for CloudTrail to ingest events from a partner or external source\cr
\link[paws.management:cloudtrail_create_dashboard]{create_dashboard} \tab Creates a custom dashboard or the Highlights dashboard\cr
\link[paws.management:cloudtrail_create_event_data_store]{create_event_data_store} \tab Creates a new event data store\cr
\link[paws.management:cloudtrail_create_trail]{create_trail} \tab Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket\cr
\link[paws.management:cloudtrail_delete_channel]{delete_channel} \tab Deletes a channel\cr
\link[paws.management:cloudtrail_delete_dashboard]{delete_dashboard} \tab Deletes the specified dashboard\cr
\link[paws.management:cloudtrail_delete_event_data_store]{delete_event_data_store} \tab Disables the event data store specified by EventDataStore, which accepts an event data store ARN\cr
\link[paws.management:cloudtrail_delete_resource_policy]{delete_resource_policy} \tab Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel\cr
\link[paws.management:cloudtrail_delete_trail]{delete_trail} \tab Deletes a trail\cr
\link[paws.management:cloudtrail_deregister_organization_delegated_admin]{deregister_organization_delegated_admin} \tab Removes CloudTrail delegated administrator permissions from a member account in an organization\cr
\link[paws.management:cloudtrail_describe_query]{describe_query} \tab Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status\cr
\link[paws.management:cloudtrail_describe_trails]{describe_trails} \tab Retrieves settings for one or more trails associated with the current Region for your account\cr
\link[paws.management:cloudtrail_disable_federation]{disable_federation} \tab Disables Lake query federation on the specified event data store\cr
\link[paws.management:cloudtrail_enable_federation]{enable_federation} \tab Enables Lake query federation on the specified event data store\cr
\link[paws.management:cloudtrail_generate_query]{generate_query} \tab Generates a query from a natural language prompt\cr
\link[paws.management:cloudtrail_get_channel]{get_channel} \tab Returns information about a specific channel\cr
\link[paws.management:cloudtrail_get_dashboard]{get_dashboard} \tab Returns the specified dashboard\cr
\link[paws.management:cloudtrail_get_event_data_store]{get_event_data_store} \tab Returns information about an event data store specified as either an ARN or the ID portion of the ARN\cr
\link[paws.management:cloudtrail_get_event_selectors]{get_event_selectors} \tab Describes the settings for the event selectors that you configured for your trail\cr
\link[paws.management:cloudtrail_get_import]{get_import} \tab Returns information about a specific import\cr
\link[paws.management:cloudtrail_get_insight_selectors]{get_insight_selectors} \tab Describes the settings for the Insights event selectors that you configured for your trail or event data store\cr
\link[paws.management:cloudtrail_get_query_results]{get_query_results} \tab Gets event data results of a query\cr
\link[paws.management:cloudtrail_get_resource_policy]{get_resource_policy} \tab Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store, dashboard, or channel\cr
\link[paws.management:cloudtrail_get_trail]{get_trail} \tab Returns settings information for a specified trail\cr
\link[paws.management:cloudtrail_get_trail_status]{get_trail_status} \tab Returns a JSON-formatted list of information about the specified trail\cr
\link[paws.management:cloudtrail_list_channels]{list_channels} \tab Lists the channels in the current account, and their source names\cr
\link[paws.management:cloudtrail_list_dashboards]{list_dashboards} \tab Returns information about all dashboards in the account, in the current Region\cr
\link[paws.management:cloudtrail_list_event_data_stores]{list_event_data_stores} \tab Returns information about all event data stores in the account, in the current Region\cr
\link[paws.management:cloudtrail_list_import_failures]{list_import_failures} \tab Returns a list of failures for the specified import\cr
\link[paws.management:cloudtrail_list_imports]{list_imports} \tab Returns information on all imports, or a select set of imports by ImportStatus or Destination\cr
\link[paws.management:cloudtrail_list_insights_metric_data]{list_insights_metric_data} \tab Returns Insights metrics data for trails that have enabled Insights\cr
\link[paws.management:cloudtrail_list_public_keys]{list_public_keys} \tab Returns all public keys whose private keys were used to sign the digest files within the specified time range\cr
\link[paws.management:cloudtrail_list_queries]{list_queries} \tab Returns a list of queries and query statuses for the past seven days\cr
\link[paws.management:cloudtrail_list_tags]{list_tags} \tab Lists the tags for the specified trails, event data stores, dashboards, or channels in the current Region\cr
\link[paws.management:cloudtrail_list_trails]{list_trails} \tab Lists trails that are in the current account\cr
\link[paws.management:cloudtrail_lookup_events]{lookup_events} \tab Looks up management events or CloudTrail Insights events that are captured by CloudTrail\cr
\link[paws.management:cloudtrail_put_event_selectors]{put_event_selectors} \tab Configures event selectors (also referred to as basic event selectors) or advanced event selectors for your trail\cr
\link[paws.management:cloudtrail_put_insight_selectors]{put_insight_selectors} \tab Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail or event data store\cr
\link[paws.management:cloudtrail_put_resource_policy]{put_resource_policy} \tab Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel\cr
\link[paws.management:cloudtrail_register_organization_delegated_admin]{register_organization_delegated_admin} \tab Registers an organization’s member account as the CloudTrail delegated administrator\cr
\link[paws.management:cloudtrail_remove_tags]{remove_tags} \tab Removes the specified tags from a trail, event data store, dashboard, or channel\cr
\link[paws.management:cloudtrail_restore_event_data_store]{restore_event_data_store} \tab Restores a deleted event data store specified by EventDataStore, which accepts an event data store ARN\cr
\link[paws.management:cloudtrail_start_dashboard_refresh]{start_dashboard_refresh} \tab Starts a refresh of the specified dashboard\cr
\link[paws.management:cloudtrail_start_event_data_store_ingestion]{start_event_data_store_ingestion} \tab Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN\cr
\link[paws.management:cloudtrail_start_import]{start_import} \tab Starts an import of logged trail events from a source S3 bucket to a destination event data store\cr
\link[paws.management:cloudtrail_start_logging]{start_logging} \tab Starts the recording of Amazon Web Services API calls and log file delivery for a trail\cr
\link[paws.management:cloudtrail_start_query]{start_query} \tab Starts a CloudTrail Lake query\cr
\link[paws.management:cloudtrail_stop_event_data_store_ingestion]{stop_event_data_store_ingestion} \tab Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN\cr
\link[paws.management:cloudtrail_stop_import]{stop_import} \tab Stops a specified import\cr
\link[paws.management:cloudtrail_stop_logging]{stop_logging} \tab Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail\cr
\link[paws.management:cloudtrail_update_channel]{update_channel} \tab Updates a channel specified by a required channel ARN or UUID\cr
\link[paws.management:cloudtrail_update_dashboard]{update_dashboard} \tab Updates the specified dashboard\cr
\link[paws.management:cloudtrail_update_event_data_store]{update_event_data_store} \tab Updates an event data store\cr
\link[paws.management:cloudtrail_update_trail]{update_trail} \tab Updates trail settings that control what events you are logging, and how to handle log files
}
}

\examples{
\dontrun{
svc <- cloudtrail()
svc$add_tags(
  Foo = 123
)
}

}
