% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{eventbridgescheduler}
\alias{eventbridgescheduler}
\title{Amazon EventBridge Scheduler}
\usage{
eventbridgescheduler(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon EventBridge Scheduler is a serverless scheduler that allows you
to create, run, and manage tasks from one central, managed service.
EventBridge Scheduler delivers your tasks reliably, with built-in
mechanisms that adjust your schedules based on the availability of
downstream targets. The following reference lists the available API
actions, and data types for EventBridge Scheduler.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- eventbridgescheduler(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.application.integration:eventbridgescheduler_create_schedule]{create_schedule} \tab Creates the specified schedule\cr
\link[paws.application.integration:eventbridgescheduler_create_schedule_group]{create_schedule_group} \tab Creates the specified schedule group\cr
\link[paws.application.integration:eventbridgescheduler_delete_schedule]{delete_schedule} \tab Deletes the specified schedule\cr
\link[paws.application.integration:eventbridgescheduler_delete_schedule_group]{delete_schedule_group} \tab Deletes the specified schedule group\cr
\link[paws.application.integration:eventbridgescheduler_get_schedule]{get_schedule} \tab Retrieves the specified schedule\cr
\link[paws.application.integration:eventbridgescheduler_get_schedule_group]{get_schedule_group} \tab Retrieves the specified schedule group\cr
\link[paws.application.integration:eventbridgescheduler_list_schedule_groups]{list_schedule_groups} \tab Returns a paginated list of your schedule groups\cr
\link[paws.application.integration:eventbridgescheduler_list_schedules]{list_schedules} \tab Returns a paginated list of your EventBridge Scheduler schedules\cr
\link[paws.application.integration:eventbridgescheduler_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags associated with the Scheduler resource\cr
\link[paws.application.integration:eventbridgescheduler_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource\cr
\link[paws.application.integration:eventbridgescheduler_untag_resource]{untag_resource} \tab Removes one or more tags from the specified EventBridge Scheduler schedule group\cr
\link[paws.application.integration:eventbridgescheduler_update_schedule]{update_schedule} \tab Updates the specified schedule
}
}

\examples{
\dontrun{
svc <- eventbridgescheduler()
svc$create_schedule(
  Foo = 123
)
}

}
