% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{appfabric}
\alias{appfabric}
\title{AppFabric}
\usage{
appfabric(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Web Services AppFabric quickly connects software as a service
(SaaS) applications across your organization. This allows IT and
security teams to easily manage and secure applications using a standard
schema, and employees can complete everyday tasks faster using
generative artificial intelligence (AI). You can use these APIs to
complete AppFabric tasks, such as setting up audit log ingestions or
viewing user access. For more information about AppFabric, including the
required permissions to use the service, see the \href{https://docs.aws.amazon.com/appfabric/latest/adminguide/}{Amazon Web Services AppFabric Administration Guide}. For
more information about using the Command Line Interface (CLI) to manage
your AppFabric resources, see the \href{https://docs.aws.amazon.com/cli/latest/reference/appfabric/}{AppFabric section of the CLI Reference}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- appfabric(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.networking:appfabric_batch_get_user_access_tasks]{batch_get_user_access_tasks} \tab Gets user access details in a batch request\cr
\link[paws.networking:appfabric_connect_app_authorization]{connect_app_authorization} \tab Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call the APIs of the application\cr
\link[paws.networking:appfabric_create_app_authorization]{create_app_authorization} \tab Creates an app authorization within an app bundle, which allows AppFabric to connect to an application\cr
\link[paws.networking:appfabric_create_app_bundle]{create_app_bundle} \tab Creates an app bundle to collect data from an application using AppFabric\cr
\link[paws.networking:appfabric_create_ingestion]{create_ingestion} \tab Creates a data ingestion for an application\cr
\link[paws.networking:appfabric_create_ingestion_destination]{create_ingestion_destination} \tab Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered\cr
\link[paws.networking:appfabric_delete_app_authorization]{delete_app_authorization} \tab Deletes an app authorization\cr
\link[paws.networking:appfabric_delete_app_bundle]{delete_app_bundle} \tab Deletes an app bundle\cr
\link[paws.networking:appfabric_delete_ingestion]{delete_ingestion} \tab Deletes an ingestion\cr
\link[paws.networking:appfabric_delete_ingestion_destination]{delete_ingestion_destination} \tab Deletes an ingestion destination\cr
\link[paws.networking:appfabric_get_app_authorization]{get_app_authorization} \tab Returns information about an app authorization\cr
\link[paws.networking:appfabric_get_app_bundle]{get_app_bundle} \tab Returns information about an app bundle\cr
\link[paws.networking:appfabric_get_ingestion]{get_ingestion} \tab Returns information about an ingestion\cr
\link[paws.networking:appfabric_get_ingestion_destination]{get_ingestion_destination} \tab Returns information about an ingestion destination\cr
\link[paws.networking:appfabric_list_app_authorizations]{list_app_authorizations} \tab Returns a list of all app authorizations configured for an app bundle\cr
\link[paws.networking:appfabric_list_app_bundles]{list_app_bundles} \tab Returns a list of app bundles\cr
\link[paws.networking:appfabric_list_ingestion_destinations]{list_ingestion_destinations} \tab Returns a list of all ingestion destinations configured for an ingestion\cr
\link[paws.networking:appfabric_list_ingestions]{list_ingestions} \tab Returns a list of all ingestions configured for an app bundle\cr
\link[paws.networking:appfabric_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags for a resource\cr
\link[paws.networking:appfabric_start_ingestion]{start_ingestion} \tab Starts (enables) an ingestion, which collects data from an application\cr
\link[paws.networking:appfabric_start_user_access_tasks]{start_user_access_tasks} \tab Starts the tasks to search user access status for a specific email address\cr
\link[paws.networking:appfabric_stop_ingestion]{stop_ingestion} \tab Stops (disables) an ingestion\cr
\link[paws.networking:appfabric_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified resource\cr
\link[paws.networking:appfabric_untag_resource]{untag_resource} \tab Removes a tag or tags from a resource\cr
\link[paws.networking:appfabric_update_app_authorization]{update_app_authorization} \tab Updates an app authorization within an app bundle, which allows AppFabric to connect to an application\cr
\link[paws.networking:appfabric_update_ingestion_destination]{update_ingestion_destination} \tab Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered
}
}

\examples{
\dontrun{
svc <- appfabric()
svc$batch_get_user_access_tasks(
  Foo = 123
)
}

}
