% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{comprehendmedical}
\alias{comprehendmedical}
\title{AWS Comprehend Medical}
\usage{
comprehendmedical(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Comprehend Medical extracts structured information from unstructured
clinical text. Use these actions to gain insight in your documents.
}
\section{Service syntax}{
\preformatted{svc <- comprehendmedical(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=comprehendmedical_detect_entities]{detect_entities} \tab Inspects the clinical text for a variety of medical entities and returns specific information about them such as entity category, location, and confidence score on that information \cr
\link[=comprehendmedical_detect_phi]{detect_phi} \tab Inspects the clinical text for personal health information (PHI) entities and entity category, location, and confidence score on that information
}
}

\examples{
\donttest{svc <- comprehendmedical()
svc$detect_entities(
  Foo = 123
)}

}
