% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_restore_job}
\alias{backup_start_restore_job}
\title{Recovers the saved resource identified by an Amazon Resource Name (ARN)}
\usage{
backup_start_restore_job(
  RecoveryPointArn,
  Metadata,
  IamRoleArn = NULL,
  IdempotencyToken = NULL,
  ResourceType = NULL,
  CopySourceTagsToRestoredResource = NULL
)
}
\arguments{
\item{RecoveryPointArn}{[required] An ARN that uniquely identifies a recovery point; for example,
\verb{arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45}.}

\item{Metadata}{[required] A set of metadata key-value pairs.

You can get configuration metadata about a resource at the time it was
backed up by calling
\code{\link[=backup_get_recovery_point_restore_metadata]{get_recovery_point_restore_metadata}}.
However, values in addition to those provided by
\code{\link[=backup_get_recovery_point_restore_metadata]{get_recovery_point_restore_metadata}}
might be required to restore a resource. For example, you might need to
provide a new resource name if the original already exists.

For more information about the metadata for each resource, see the
following:
\itemize{
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-aur.html#aur-restore-cli}{Metadata for Amazon Aurora}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-docdb.html#docdb-restore-cli}{Metadata for Amazon DocumentDB}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-application-stacks.html#restoring-cfn-cli}{Metadata for CloudFormation}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-dynamodb.html#ddb-restore-cli}{Metadata for Amazon DynamoDB}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ebs.html#ebs-restore-cli}{Metadata for Amazon EBS}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-ec2.html#restoring-ec2-cli}{Metadata for Amazon EC2}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-efs.html#efs-restore-cli}{Metadata for Amazon EFS}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-fsx.html#fsx-restore-cli}{Metadata for Amazon FSx}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-nep.html#nep-restore-cli}{Metadata for Amazon Neptune}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-rds.html#rds-restore-cli}{Metadata for Amazon RDS}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/redshift-restores.html#redshift-restore-api}{Metadata for Amazon Redshift}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-storage-gateway.html#restoring-sgw-cli}{Metadata for Storage Gateway}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-s3.html#s3-restore-cli}{Metadata for Amazon S3}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/timestream-restore.html#timestream-restore-api}{Metadata for Amazon Timestream}
\item \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/restoring-vm.html#vm-restore-cli}{Metadata for virtual machines}
}}

\item{IamRoleArn}{The Amazon Resource Name (ARN) of the IAM role that Backup uses to
create the target resource; for example:
\verb{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to
\code{\link[=backup_start_restore_job]{start_restore_job}}. Retrying a successful
request with the same idempotency token results in a success message
with no action taken.}

\item{ResourceType}{Starts a job to restore a recovery point for one of the following
resources:
\itemize{
\item \code{Aurora} - Amazon Aurora
\item \code{DocumentDB} - Amazon DocumentDB
\item \code{CloudFormation} - CloudFormation
\item \code{DynamoDB} - Amazon DynamoDB
\item \code{EBS} - Amazon Elastic Block Store
\item \code{EC2} - Amazon Elastic Compute Cloud
\item \code{EFS} - Amazon Elastic File System
\item \code{FSx} - Amazon FSx
\item \code{Neptune} - Amazon Neptune
\item \code{RDS} - Amazon Relational Database Service
\item \code{Redshift} - Amazon Redshift
\item \verb{Storage Gateway} - Storage Gateway
\item \code{S3} - Amazon Simple Storage Service
\item \code{Timestream} - Amazon Timestream
\item \code{VirtualMachine} - Virtual machines
}}

\item{CopySourceTagsToRestoredResource}{This is an optional parameter. If this equals \code{True}, tags included in
the backup will be copied to the restored resource.

This can only be applied to backups created through Backup.}
}
\description{
Recovers the saved resource identified by an Amazon Resource Name (ARN).

See \url{https://www.paws-r-sdk.com/docs/backup_start_restore_job/} for full documentation.
}
\keyword{internal}
