# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Omics
#'
#' @description
#' This is the *AWS HealthOmics API Reference*. For an introduction to the
#' service, see [What is AWS
#' HealthOmics?](https://docs.aws.amazon.com/omics/latest/dev/) in the *AWS
#' HealthOmics User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- omics(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- omics()
#' svc$abort_multipart_read_set_upload(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=omics_abort_multipart_read_set_upload]{abort_multipart_read_set_upload} \tab Stops a multipart upload\cr
#'  \link[=omics_accept_share]{accept_share} \tab Accept a resource share request\cr
#'  \link[=omics_batch_delete_read_set]{batch_delete_read_set} \tab Deletes one or more read sets\cr
#'  \link[=omics_cancel_annotation_import_job]{cancel_annotation_import_job} \tab Cancels an annotation import job\cr
#'  \link[=omics_cancel_run]{cancel_run} \tab Cancels a run\cr
#'  \link[=omics_cancel_variant_import_job]{cancel_variant_import_job} \tab Cancels a variant import job\cr
#'  \link[=omics_complete_multipart_read_set_upload]{complete_multipart_read_set_upload} \tab Concludes a multipart upload once you have uploaded all the components\cr
#'  \link[=omics_create_annotation_store]{create_annotation_store} \tab Creates an annotation store\cr
#'  \link[=omics_create_annotation_store_version]{create_annotation_store_version} \tab Creates a new version of an annotation store\cr
#'  \link[=omics_create_multipart_read_set_upload]{create_multipart_read_set_upload} \tab Begins a multipart read set upload\cr
#'  \link[=omics_create_reference_store]{create_reference_store} \tab Creates a reference store\cr
#'  \link[=omics_create_run_cache]{create_run_cache} \tab You can create a run cache to save the task outputs from completed tasks in a run for a private workflow\cr
#'  \link[=omics_create_run_group]{create_run_group} \tab You can optionally create a run group to limit the compute resources for the runs that you add to the group\cr
#'  \link[=omics_create_sequence_store]{create_sequence_store} \tab Creates a sequence store\cr
#'  \link[=omics_create_share]{create_share} \tab Creates a cross-account shared resource\cr
#'  \link[=omics_create_variant_store]{create_variant_store} \tab Creates a variant store\cr
#'  \link[=omics_create_workflow]{create_workflow} \tab Creates a workflow\cr
#'  \link[=omics_delete_annotation_store]{delete_annotation_store} \tab Deletes an annotation store\cr
#'  \link[=omics_delete_annotation_store_versions]{delete_annotation_store_versions} \tab Deletes one or multiple versions of an annotation store\cr
#'  \link[=omics_delete_reference]{delete_reference} \tab Deletes a genome reference\cr
#'  \link[=omics_delete_reference_store]{delete_reference_store} \tab Deletes a genome reference store\cr
#'  \link[=omics_delete_run]{delete_run} \tab Deletes a workflow run\cr
#'  \link[=omics_delete_run_cache]{delete_run_cache} \tab Delete a run cache\cr
#'  \link[=omics_delete_run_group]{delete_run_group} \tab Deletes a workflow run group\cr
#'  \link[=omics_delete_s3_access_policy]{delete_s3_access_policy} \tab Deletes an access policy for the specified store\cr
#'  \link[=omics_delete_sequence_store]{delete_sequence_store} \tab Deletes a sequence store\cr
#'  \link[=omics_delete_share]{delete_share} \tab Deletes a resource share\cr
#'  \link[=omics_delete_variant_store]{delete_variant_store} \tab Deletes a variant store\cr
#'  \link[=omics_delete_workflow]{delete_workflow} \tab Deletes a workflow\cr
#'  \link[=omics_get_annotation_import_job]{get_annotation_import_job} \tab Gets information about an annotation import job\cr
#'  \link[=omics_get_annotation_store]{get_annotation_store} \tab Gets information about an annotation store\cr
#'  \link[=omics_get_annotation_store_version]{get_annotation_store_version} \tab Retrieves the metadata for an annotation store version\cr
#'  \link[=omics_get_read_set]{get_read_set} \tab Gets a file from a read set\cr
#'  \link[=omics_get_read_set_activation_job]{get_read_set_activation_job} \tab Gets information about a read set activation job\cr
#'  \link[=omics_get_read_set_export_job]{get_read_set_export_job} \tab Gets information about a read set export job\cr
#'  \link[=omics_get_read_set_import_job]{get_read_set_import_job} \tab Gets information about a read set import job\cr
#'  \link[=omics_get_read_set_metadata]{get_read_set_metadata} \tab Gets details about a read set\cr
#'  \link[=omics_get_reference]{get_reference} \tab Gets a reference file\cr
#'  \link[=omics_get_reference_import_job]{get_reference_import_job} \tab Gets information about a reference import job\cr
#'  \link[=omics_get_reference_metadata]{get_reference_metadata} \tab Gets information about a genome reference's metadata\cr
#'  \link[=omics_get_reference_store]{get_reference_store} \tab Gets information about a reference store\cr
#'  \link[=omics_get_run]{get_run} \tab Gets information about a workflow run\cr
#'  \link[=omics_get_run_cache]{get_run_cache} \tab Retrieve the details for the specified run cache\cr
#'  \link[=omics_get_run_group]{get_run_group} \tab Gets information about a workflow run group\cr
#'  \link[=omics_get_run_task]{get_run_task} \tab Gets information about a workflow run task\cr
#'  \link[=omics_get_s3_access_policy]{get_s3_access_policy} \tab Retrieves details about an access policy on a given store\cr
#'  \link[=omics_get_sequence_store]{get_sequence_store} \tab Gets information about a sequence store\cr
#'  \link[=omics_get_share]{get_share} \tab Retrieves the metadata for the specified resource share\cr
#'  \link[=omics_get_variant_import_job]{get_variant_import_job} \tab Gets information about a variant import job\cr
#'  \link[=omics_get_variant_store]{get_variant_store} \tab Gets information about a variant store\cr
#'  \link[=omics_get_workflow]{get_workflow} \tab Gets information about a workflow\cr
#'  \link[=omics_list_annotation_import_jobs]{list_annotation_import_jobs} \tab Retrieves a list of annotation import jobs\cr
#'  \link[=omics_list_annotation_stores]{list_annotation_stores} \tab Retrieves a list of annotation stores\cr
#'  \link[=omics_list_annotation_store_versions]{list_annotation_store_versions} \tab Lists the versions of an annotation store\cr
#'  \link[=omics_list_multipart_read_set_uploads]{list_multipart_read_set_uploads} \tab Lists multipart read set uploads and for in progress uploads\cr
#'  \link[=omics_list_read_set_activation_jobs]{list_read_set_activation_jobs} \tab Retrieves a list of read set activation jobs\cr
#'  \link[=omics_list_read_set_export_jobs]{list_read_set_export_jobs} \tab Retrieves a list of read set export jobs\cr
#'  \link[=omics_list_read_set_import_jobs]{list_read_set_import_jobs} \tab Retrieves a list of read set import jobs\cr
#'  \link[=omics_list_read_sets]{list_read_sets} \tab Retrieves a list of read sets\cr
#'  \link[=omics_list_read_set_upload_parts]{list_read_set_upload_parts} \tab This operation will list all parts in a requested multipart upload for a sequence store\cr
#'  \link[=omics_list_reference_import_jobs]{list_reference_import_jobs} \tab Retrieves a list of reference import jobs\cr
#'  \link[=omics_list_references]{list_references} \tab Retrieves a list of references\cr
#'  \link[=omics_list_reference_stores]{list_reference_stores} \tab Retrieves a list of reference stores\cr
#'  \link[=omics_list_run_caches]{list_run_caches} \tab Retrieves a list of your run caches\cr
#'  \link[=omics_list_run_groups]{list_run_groups} \tab Retrieves a list of run groups\cr
#'  \link[=omics_list_runs]{list_runs} \tab Retrieves a list of runs\cr
#'  \link[=omics_list_run_tasks]{list_run_tasks} \tab Retrieves a list of tasks for a run\cr
#'  \link[=omics_list_sequence_stores]{list_sequence_stores} \tab Retrieves a list of sequence stores\cr
#'  \link[=omics_list_shares]{list_shares} \tab Retrieves the resource shares associated with an account\cr
#'  \link[=omics_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves a list of tags for a resource\cr
#'  \link[=omics_list_variant_import_jobs]{list_variant_import_jobs} \tab Retrieves a list of variant import jobs\cr
#'  \link[=omics_list_variant_stores]{list_variant_stores} \tab Retrieves a list of variant stores\cr
#'  \link[=omics_list_workflows]{list_workflows} \tab Retrieves a list of workflows\cr
#'  \link[=omics_put_s3_access_policy]{put_s3_access_policy} \tab Adds an access policy to the specified store\cr
#'  \link[=omics_start_annotation_import_job]{start_annotation_import_job} \tab Starts an annotation import job\cr
#'  \link[=omics_start_read_set_activation_job]{start_read_set_activation_job} \tab Activates an archived read set\cr
#'  \link[=omics_start_read_set_export_job]{start_read_set_export_job} \tab Exports a read set to Amazon S3\cr
#'  \link[=omics_start_read_set_import_job]{start_read_set_import_job} \tab Starts a read set import job\cr
#'  \link[=omics_start_reference_import_job]{start_reference_import_job} \tab Starts a reference import job\cr
#'  \link[=omics_start_run]{start_run} \tab Starts a workflow run\cr
#'  \link[=omics_start_variant_import_job]{start_variant_import_job} \tab Starts a variant import job\cr
#'  \link[=omics_tag_resource]{tag_resource} \tab Tags a resource\cr
#'  \link[=omics_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
#'  \link[=omics_update_annotation_store]{update_annotation_store} \tab Updates an annotation store\cr
#'  \link[=omics_update_annotation_store_version]{update_annotation_store_version} \tab Updates the description of an annotation store version\cr
#'  \link[=omics_update_run_cache]{update_run_cache} \tab Update a run cache\cr
#'  \link[=omics_update_run_group]{update_run_group} \tab Updates a run group\cr
#'  \link[=omics_update_sequence_store]{update_sequence_store} \tab Update one or more parameters for the sequence store\cr
#'  \link[=omics_update_variant_store]{update_variant_store} \tab Updates a variant store\cr
#'  \link[=omics_update_workflow]{update_workflow} \tab Updates a workflow\cr
#'  \link[=omics_upload_read_set_part]{upload_read_set_part} \tab This operation uploads a specific part of a read set
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname omics
#' @export
omics <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .omics$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.omics <- list()

.omics$operations <- list()

.omics$metadata <- list(
  service_name = "omics",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "omics.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Omics",
  api_version = "2022-11-28",
  signing_name = "omics",
  json_version = "",
  target_prefix = ""
)

.omics$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.omics$metadata, handlers, config, op)
}
