% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_tag_resource}
\alias{backup_tag_resource}
\title{Assigns a set of key-value pairs to a recovery point, backup plan, or
backup vault identified by an Amazon Resource Name (ARN)}
\usage{
backup_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] An ARN that uniquely identifies a resource. The format of the ARN
depends on the type of the tagged resource.

ARNs that do not include \code{backup} are incompatible with tagging.
\code{\link[=backup_tag_resource]{tag_resource}} and
\code{\link[=backup_untag_resource]{untag_resource}} with invalid ARNs will result
in an error. Acceptable ARN content can include
\code{arn:aws:backup:us-east}. Invalid ARN content may look like
\code{arn:aws:ec2:us-east}.}

\item{Tags}{[required] Key-value pairs that are used to help organize your resources. You can
assign your own metadata to the resources you create. For clarity, this
is the structure to assign tags: \verb{[\{"Key":"string","Value":"string"\}]}.}
}
\description{
Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).

See \url{https://www.paws-r-sdk.com/docs/backup_tag_resource/} for full documentation.
}
\keyword{internal}
