% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_update_report_plan}
\alias{backup_update_report_plan}
\title{Updates an existing report plan identified by its ReportPlanName with
the input document in JSON format}
\usage{
backup_update_report_plan(
  ReportPlanName,
  ReportPlanDescription = NULL,
  ReportDeliveryChannel = NULL,
  ReportSetting = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{ReportPlanName}{[required] The unique name of the report plan. This name is between 1 and 256
characters, starting with a letter, and consisting of letters (a-z,
A-Z), numbers (0-9), and underscores (_).}

\item{ReportPlanDescription}{An optional description of the report plan with a maximum 1,024
characters.}

\item{ReportDeliveryChannel}{A structure that contains information about where to deliver your
reports, specifically your Amazon S3 bucket name, S3 key prefix, and the
formats of your reports.}

\item{ReportSetting}{Identifies the report template for the report. Reports are built using a
report template. The report templates are:

\code{RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT}

If the report template is \code{RESOURCE_COMPLIANCE_REPORT} or
\code{CONTROL_COMPLIANCE_REPORT}, this API resource also describes the report
coverage by Amazon Web Services Regions and frameworks.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to \code{UpdateReportPlanInput}. Retrying a
successful request with the same idempotency token results in a success
message with no action taken.}
}
\description{
Updates an existing report plan identified by its \code{ReportPlanName} with the input document in JSON format.

See \url{https://www.paws-r-sdk.com/docs/backup_update_report_plan/} for full documentation.
}
\keyword{internal}
