% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_copy_jobs}
\alias{backup_list_copy_jobs}
\title{Returns metadata about your copy jobs}
\usage{
backup_list_copy_jobs(
  NextToken = NULL,
  MaxResults = NULL,
  ByResourceArn = NULL,
  ByState = NULL,
  ByCreatedBefore = NULL,
  ByCreatedAfter = NULL,
  ByResourceType = NULL,
  ByDestinationVaultArn = NULL,
  ByAccountId = NULL,
  ByCompleteBefore = NULL,
  ByCompleteAfter = NULL,
  ByParentJobId = NULL
)
}
\arguments{
\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return maxResults number of items, NextToken
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{ByResourceArn}{Returns only copy jobs that match the specified resource Amazon Resource
Name (ARN).}

\item{ByState}{Returns only copy jobs that are in the specified state.}

\item{ByCreatedBefore}{Returns only copy jobs that were created before the specified date.}

\item{ByCreatedAfter}{Returns only copy jobs that were created after the specified date.}

\item{ByResourceType}{Returns only backup jobs for the specified resources:
\itemize{
\item \code{Aurora} for Amazon Aurora
\item \code{DocumentDB} for Amazon DocumentDB (with MongoDB compatibility)
\item \code{DynamoDB} for Amazon DynamoDB
\item \code{EBS} for Amazon Elastic Block Store
\item \code{EC2} for Amazon Elastic Compute Cloud
\item \code{EFS} for Amazon Elastic File System
\item \code{FSx} for Amazon FSx
\item \code{Neptune} for Amazon Neptune
\item \code{RDS} for Amazon Relational Database Service
\item \verb{Storage Gateway} for Storage Gateway
\item \code{S3} for Amazon S3
\item \code{VirtualMachine} for virtual machines
}}

\item{ByDestinationVaultArn}{An Amazon Resource Name (ARN) that uniquely identifies a source backup
vault to copy from; for example,
\code{arn:aws:backup:us-east-1:123456789012:vault:aBackupVault}.}

\item{ByAccountId}{The account ID to list the jobs from. Returns only copy jobs associated
with the specified account ID.}

\item{ByCompleteBefore}{Returns only copy jobs completed before a date expressed in Unix format
and Coordinated Universal Time (UTC).}

\item{ByCompleteAfter}{Returns only copy jobs completed after a date expressed in Unix format
and Coordinated Universal Time (UTC).}

\item{ByParentJobId}{This is a filter to list child (nested) jobs based on parent job ID.}
}
\description{
Returns metadata about your copy jobs.

See \url{https://www.paws-r-sdk.com/docs/backup_list_copy_jobs/} for full documentation.
}
\keyword{internal}
