# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include recyclebin_service.R
NULL

#' Creates a Recycle Bin retention rule
#'
#' @description
#' Creates a Recycle Bin retention rule. For more information, see [Create Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-create-rule) in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_create_rule/](https://www.paws-r-sdk.com/docs/recyclebin_create_rule/) for full documentation.
#'
#' @param RetentionPeriod &#91;required&#93; Information about the retention period for which the retention rule is
#' to retain resources.
#' @param Description The retention rule description.
#' @param Tags Information about the tags to assign to the retention rule.
#' @param ResourceType &#91;required&#93; The resource type to be retained by the retention rule. Currently, only
#' Amazon EBS snapshots and EBS-backed AMIs are supported. To retain
#' snapshots, specify `EBS_SNAPSHOT`. To retain EBS-backed AMIs, specify
#' `EC2_IMAGE`.
#' @param ResourceTags Specifies the resource tags to use to identify resources that are to be
#' retained by a tag-level retention rule. For tag-level retention rules,
#' only deleted resources, of the specified resource type, that have one or
#' more of the specified tag key and value pairs are retained. If a
#' resource is deleted, but it does not have any of the specified tag key
#' and value pairs, it is immediately deleted without being retained by the
#' retention rule.
#' 
#' You can add the same tag key and value pair to a maximum or five
#' retention rules.
#' 
#' To create a Region-level retention rule, omit this parameter. A
#' Region-level retention rule does not have any resource tags specified.
#' It retains all deleted resources of the specified resource type in the
#' Region in which the rule is created, even if the resources are not
#' tagged.
#' @param LockConfiguration Information about the retention rule lock configuration.
#'
#' @keywords internal
#'
#' @rdname recyclebin_create_rule
recyclebin_create_rule <- function(RetentionPeriod, Description = NULL, Tags = NULL, ResourceType, ResourceTags = NULL, LockConfiguration = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/rules",
    paginator = list()
  )
  input <- .recyclebin$create_rule_input(RetentionPeriod = RetentionPeriod, Description = Description, Tags = Tags, ResourceType = ResourceType, ResourceTags = ResourceTags, LockConfiguration = LockConfiguration)
  output <- .recyclebin$create_rule_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$create_rule <- recyclebin_create_rule

#' Deletes a Recycle Bin retention rule
#'
#' @description
#' Deletes a Recycle Bin retention rule. For more information, see [Delete Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-delete-rule) in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_delete_rule/](https://www.paws-r-sdk.com/docs/recyclebin_delete_rule/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The unique ID of the retention rule.
#'
#' @keywords internal
#'
#' @rdname recyclebin_delete_rule
recyclebin_delete_rule <- function(Identifier) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "DELETE",
    http_path = "/rules/{identifier}",
    paginator = list()
  )
  input <- .recyclebin$delete_rule_input(Identifier = Identifier)
  output <- .recyclebin$delete_rule_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$delete_rule <- recyclebin_delete_rule

#' Gets information about a Recycle Bin retention rule
#'
#' @description
#' Gets information about a Recycle Bin retention rule.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_get_rule/](https://www.paws-r-sdk.com/docs/recyclebin_get_rule/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The unique ID of the retention rule.
#'
#' @keywords internal
#'
#' @rdname recyclebin_get_rule
recyclebin_get_rule <- function(Identifier) {
  op <- new_operation(
    name = "GetRule",
    http_method = "GET",
    http_path = "/rules/{identifier}",
    paginator = list()
  )
  input <- .recyclebin$get_rule_input(Identifier = Identifier)
  output <- .recyclebin$get_rule_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$get_rule <- recyclebin_get_rule

#' Lists the Recycle Bin retention rules in the Region
#'
#' @description
#' Lists the Recycle Bin retention rules in the Region.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_list_rules/](https://www.paws-r-sdk.com/docs/recyclebin_list_rules/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param ResourceType &#91;required&#93; The resource type retained by the retention rule. Only retention rules
#' that retain the specified resource type are listed. Currently, only
#' Amazon EBS snapshots and EBS-backed AMIs are supported. To list
#' retention rules that retain snapshots, specify `EBS_SNAPSHOT`. To list
#' retention rules that retain EBS-backed AMIs, specify `EC2_IMAGE`.
#' @param ResourceTags Information about the resource tags used to identify resources that are
#' retained by the retention rule.
#' @param LockState The lock state of the retention rules to list. Only retention rules with
#' the specified lock state are returned.
#'
#' @keywords internal
#'
#' @rdname recyclebin_list_rules
recyclebin_list_rules <- function(MaxResults = NULL, NextToken = NULL, ResourceType, ResourceTags = NULL, LockState = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/list-rules",
    paginator = list()
  )
  input <- .recyclebin$list_rules_input(MaxResults = MaxResults, NextToken = NextToken, ResourceType = ResourceType, ResourceTags = ResourceTags, LockState = LockState)
  output <- .recyclebin$list_rules_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$list_rules <- recyclebin_list_rules

#' Lists the tags assigned to a retention rule
#'
#' @description
#' Lists the tags assigned to a retention rule.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/recyclebin_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the retention rule.
#'
#' @keywords internal
#'
#' @rdname recyclebin_list_tags_for_resource
recyclebin_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .recyclebin$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .recyclebin$list_tags_for_resource_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$list_tags_for_resource <- recyclebin_list_tags_for_resource

#' Locks a retention rule
#'
#' @description
#' Locks a retention rule. A locked retention rule can't be modified or deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_lock_rule/](https://www.paws-r-sdk.com/docs/recyclebin_lock_rule/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The unique ID of the retention rule.
#' @param LockConfiguration &#91;required&#93; Information about the retention rule lock configuration.
#'
#' @keywords internal
#'
#' @rdname recyclebin_lock_rule
recyclebin_lock_rule <- function(Identifier, LockConfiguration) {
  op <- new_operation(
    name = "LockRule",
    http_method = "PATCH",
    http_path = "/rules/{identifier}/lock",
    paginator = list()
  )
  input <- .recyclebin$lock_rule_input(Identifier = Identifier, LockConfiguration = LockConfiguration)
  output <- .recyclebin$lock_rule_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$lock_rule <- recyclebin_lock_rule

#' Assigns tags to the specified retention rule
#'
#' @description
#' Assigns tags to the specified retention rule.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_tag_resource/](https://www.paws-r-sdk.com/docs/recyclebin_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the retention rule.
#' @param Tags &#91;required&#93; Information about the tags to assign to the retention rule.
#'
#' @keywords internal
#'
#' @rdname recyclebin_tag_resource
recyclebin_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .recyclebin$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .recyclebin$tag_resource_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$tag_resource <- recyclebin_tag_resource

#' Unlocks a retention rule
#'
#' @description
#' Unlocks a retention rule. After a retention rule is unlocked, it can be modified or deleted only after the unlock delay period expires.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_unlock_rule/](https://www.paws-r-sdk.com/docs/recyclebin_unlock_rule/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The unique ID of the retention rule.
#'
#' @keywords internal
#'
#' @rdname recyclebin_unlock_rule
recyclebin_unlock_rule <- function(Identifier) {
  op <- new_operation(
    name = "UnlockRule",
    http_method = "PATCH",
    http_path = "/rules/{identifier}/unlock",
    paginator = list()
  )
  input <- .recyclebin$unlock_rule_input(Identifier = Identifier)
  output <- .recyclebin$unlock_rule_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$unlock_rule <- recyclebin_unlock_rule

#' Unassigns a tag from a retention rule
#'
#' @description
#' Unassigns a tag from a retention rule.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_untag_resource/](https://www.paws-r-sdk.com/docs/recyclebin_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the retention rule.
#' @param TagKeys &#91;required&#93; The tag keys of the tags to unassign. All tags that have the specified
#' tag key are unassigned.
#'
#' @keywords internal
#'
#' @rdname recyclebin_untag_resource
recyclebin_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .recyclebin$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .recyclebin$untag_resource_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$untag_resource <- recyclebin_untag_resource

#' Updates an existing Recycle Bin retention rule
#'
#' @description
#' Updates an existing Recycle Bin retention rule. You can update a retention rule's description, resource tags, and retention period at any time after creation. You can't update a retention rule's resource type after creation. For more information, see [Update Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule) in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/recyclebin_update_rule/](https://www.paws-r-sdk.com/docs/recyclebin_update_rule/) for full documentation.
#'
#' @param Identifier &#91;required&#93; The unique ID of the retention rule.
#' @param RetentionPeriod Information about the retention period for which the retention rule is
#' to retain resources.
#' @param Description The retention rule description.
#' @param ResourceType This parameter is currently not supported. You can't update a retention
#' rule's resource type after creation.
#' @param ResourceTags Specifies the resource tags to use to identify resources that are to be
#' retained by a tag-level retention rule. For tag-level retention rules,
#' only deleted resources, of the specified resource type, that have one or
#' more of the specified tag key and value pairs are retained. If a
#' resource is deleted, but it does not have any of the specified tag key
#' and value pairs, it is immediately deleted without being retained by the
#' retention rule.
#' 
#' You can add the same tag key and value pair to a maximum or five
#' retention rules.
#' 
#' To create a Region-level retention rule, omit this parameter. A
#' Region-level retention rule does not have any resource tags specified.
#' It retains all deleted resources of the specified resource type in the
#' Region in which the rule is created, even if the resources are not
#' tagged.
#'
#' @keywords internal
#'
#' @rdname recyclebin_update_rule
recyclebin_update_rule <- function(Identifier, RetentionPeriod = NULL, Description = NULL, ResourceType = NULL, ResourceTags = NULL) {
  op <- new_operation(
    name = "UpdateRule",
    http_method = "PATCH",
    http_path = "/rules/{identifier}",
    paginator = list()
  )
  input <- .recyclebin$update_rule_input(Identifier = Identifier, RetentionPeriod = RetentionPeriod, Description = Description, ResourceType = ResourceType, ResourceTags = ResourceTags)
  output <- .recyclebin$update_rule_output()
  config <- get_config()
  svc <- .recyclebin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.recyclebin$operations$update_rule <- recyclebin_update_rule
