% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_policy}
\alias{s3_put_bucket_policy}
\title{Applies an Amazon S3 bucket policy to an Amazon S3 bucket}
\usage{
s3_put_bucket_policy(
  Bucket,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  ConfirmRemoveSelfBucketAccess = NULL,
  Policy,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket.}

\item{ContentMD5}{The MD5 hash of the request body.

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
using the SDK. This header will not provide any additional functionality
if not using the SDK. When sending this header, there must be a
corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{ConfirmRemoveSelfBucketAccess}{Set this parameter to true to confirm that you want to remove your
permissions to change this bucket policy in the future.}

\item{Policy}{[required] The bucket policy as a JSON document.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the \code{\link[=s3_put_bucket_policy]{put_bucket_policy}} permissions on the specified bucket and belong to the bucket owner's account in order to use this operation.

See \url{https://paws-r.github.io/docs/s3/put_bucket_policy.html} for full documentation.
}
\keyword{internal}
