% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_notification_configuration}
\alias{s3_put_bucket_notification_configuration}
\title{Enables notifications of specified events for a bucket}
\usage{
s3_put_bucket_notification_configuration(
  Bucket,
  NotificationConfiguration,
  ExpectedBucketOwner = NULL,
  SkipDestinationValidation = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket.}

\item{NotificationConfiguration}{[required]}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}

\item{SkipDestinationValidation}{Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations.
True or false value.}
}
\description{
Enables notifications of specified events for a bucket. For more information about event notifications, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/NotificationHowTo.html}{Configuring Event Notifications}.

See \url{https://paws-r.github.io/docs/s3/put_bucket_notification_configuration.html} for full documentation.
}
\keyword{internal}
