% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_public_access_block}
\alias{s3_get_public_access_block}
\title{Retrieves the PublicAccessBlock configuration for an Amazon S3 bucket}
\usage{
s3_get_public_access_block(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the Amazon S3 bucket whose \code{PublicAccessBlock} configuration
you want to retrieve.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Retrieves the \code{PublicAccessBlock} configuration for an Amazon S3 bucket. To use this operation, you must have the \code{s3:GetBucketPublicAccessBlock} permission. For more information about Amazon S3 permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html}{Specifying Permissions in a Policy}.

See \url{https://paws-r.github.io/docs/s3/get_public_access_block.html} for full documentation.
}
\keyword{internal}
