% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_delete_volume}
\alias{fsx_delete_volume}
\title{Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume}
\usage{
fsx_delete_volume(
  ClientRequestToken = NULL,
  VolumeId,
  OntapConfiguration = NULL,
  OpenZFSConfiguration = NULL
)
}
\arguments{
\item{ClientRequestToken}{}

\item{VolumeId}{[required] The ID of the volume that you are deleting.}

\item{OntapConfiguration}{For Amazon FSx for ONTAP volumes, specify whether to take a final backup
of the volume and apply tags to the backup. To apply tags to the backup,
you must have the \code{fsx:TagResource} permission.}

\item{OpenZFSConfiguration}{For Amazon FSx for OpenZFS volumes, specify whether to delete all child
volumes and snapshots.}
}
\description{
Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.

See \url{https://paws-r.github.io/docs/fsx/delete_volume.html} for full documentation.
}
\keyword{internal}
