% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_get_job_tagging}
\alias{s3control_get_job_tagging}
\title{Returns the tags on an Amazon S3 Batch Operations job}
\usage{
s3control_get_job_tagging(AccountId, JobId)
}
\arguments{
\item{AccountId}{[required] The AWS account ID associated with the Amazon S3 Batch Operations job.}

\item{JobId}{[required] The ID for the Amazon S3 Batch Operations job whose tags you want to
retrieve.}
}
\description{
Returns the tags on an Amazon S3 Batch Operations job. To use this
operation, you must have permission to perform the \code{s3:GetJobTagging}
action. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags}{Using Job Tags}
in the \emph{Amazon Simple Storage Service Developer Guide}.
}
\details{
Related actions include:
\itemize{
\item CreateJob
\item PutJobTagging
\item DeleteJobTagging
}
}
\section{Request syntax}{
\preformatted{svc$get_job_tagging(
  AccountId = "string",
  JobId = "string"
)
}
}

\keyword{internal}
