% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_describe_data_repository_tasks}
\alias{fsx_describe_data_repository_tasks}
\title{Returns the description of specific Amazon FSx for Lustre data
repository tasks, if one or more TaskIds values are provided in the
request, or if filters are used in the request}
\usage{
fsx_describe_data_repository_tasks(TaskIds, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{TaskIds}{(Optional) IDs of the tasks whose descriptions you want to retrieve
(String).}

\item{Filters}{(Optional) You can use filters to narrow the
\code{DescribeDataRepositoryTasks} response to include just tasks for
specific file systems, or tasks in a specific lifecycle state.}

\item{MaxResults}{}

\item{NextToken}{}
}
\description{
Returns the description of specific Amazon FSx for Lustre data
repository tasks, if one or more \code{TaskIds} values are provided in the
request, or if filters are used in the request. You can use filters to
narrow the response to include just tasks for specific file systems, or
tasks in a specific lifecycle state. Otherwise, it returns all data
repository tasks owned by your AWS account in the AWS Region of the
endpoint that you\'re calling.
}
\details{
When retrieving all tasks, you can paginate the response by using the
optional \code{MaxResults} parameter to limit the number of tasks returned in
a response. If more tasks remain, Amazon FSx returns a \code{NextToken} value
in the response. In this case, send a later request with the \code{NextToken}
request parameter set to the value of \code{NextToken} from the last
response.
}
\section{Request syntax}{
\preformatted{svc$describe_data_repository_tasks(
  TaskIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "file-system-id"|"task-lifecycle",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
