% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_inventory_configuration}
\alias{s3_put_bucket_inventory_configuration}
\title{This implementation of the PUT operation adds an inventory configuration
(identified by the inventory ID) to the bucket}
\usage{
s3_put_bucket_inventory_configuration(Bucket, Id,
  InventoryConfiguration)
}
\arguments{
\item{Bucket}{[required] The name of the bucket where the inventory configuration will be stored.}

\item{Id}{[required] The ID used to identify the inventory configuration.}

\item{InventoryConfiguration}{[required] Specifies the inventory configuration.}
}
\description{
This implementation of the \code{PUT} operation adds an inventory
configuration (identified by the inventory ID) to the bucket. You can
have up to 1,000 inventory configurations per bucket.
}
\details{
Amazon S3 inventory generates inventories of the objects in the bucket
on a daily or weekly basis, and the results are published to a flat
file. The bucket that is inventoried is called the \emph{source} bucket, and
the bucket where the inventory flat file is stored is called the
\emph{destination} bucket. The \emph{destination} bucket must be in the same AWS
Region as the \emph{source} bucket.

When you configure an inventory for a \emph{source} bucket, you specify the
\emph{destination} bucket where you want the inventory to be stored, and
whether to generate the inventory daily or weekly. You can also
configure what object metadata to include and whether to inventory all
object versions or only current versions. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/dev//storage-inventory.html}{Amazon S3 Inventory}
in the Amazon Simple Storage Service Developer Guide.

You must create a bucket policy on the \emph{destination} bucket to grant
permissions to Amazon S3 to write objects to the bucket in the defined
location. For an example policy, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9}{Granting Permissions for Amazon S3 Inventory and Storage Class Analysis.}

To use this operation, you must have permissions to perform the
\code{s3:PutInventoryConfiguration} action. The bucket owner has this
permission by default and can grant this permission to others. For more
information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev//using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev//s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}
in the Amazon Simple Storage Service Developer Guide.

\strong{Special Errors}
\itemize{
\item \strong{HTTP 400 Bad Request Error}
\itemize{
\item \emph{Code:} InvalidArgument
\item \emph{Cause:} Invalid Argument
}
\item \strong{HTTP 400 Bad Request Error}
\itemize{
\item \emph{Code:} TooManyConfigurations
\item \emph{Cause:} You are attempting to create a new configuration but
have already reached the 1,000-configuration limit.
}
\item \strong{HTTP 403 Forbidden Error}
\itemize{
\item \emph{Code:} AccessDenied
\item \emph{Cause:} You are not the owner of the specified bucket, or you
do not have the \code{s3:PutInventoryConfiguration} bucket permission
to set the configuration on the bucket
}
}

\strong{Related Resources}
\itemize{
\item GetBucketInventoryConfiguration
\item DeleteBucketInventoryConfiguration
\item ListBucketInventoryConfigurations
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_inventory_configuration(
  Bucket = "string",
  Id = "string",
  InventoryConfiguration = list(
    Destination = list(
      S3BucketDestination = list(
        AccountId = "string",
        Bucket = "string",
        Format = "CSV"|"ORC"|"Parquet",
        Prefix = "string",
        Encryption = list(
          SSES3 = list(),
          SSEKMS = list(
            KeyId = "string"
          )
        )
      )
    ),
    IsEnabled = TRUE|FALSE,
    Filter = list(
      Prefix = "string"
    ),
    Id = "string",
    IncludedObjectVersions = "All"|"Current",
    OptionalFields = list(
      "Size"|"LastModifiedDate"|"StorageClass"|"ETag"|"IsMultipartUploaded"|"ReplicationStatus"|"EncryptionStatus"|"ObjectLockRetainUntilDate"|"ObjectLockMode"|"ObjectLockLegalHoldStatus"|"IntelligentTieringAccessTier"
    ),
    Schedule = list(
      Frequency = "Daily"|"Weekly"
    )
  )
)
}
}

\keyword{internal}
