% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_data_repository_task}
\alias{fsx_create_data_repository_task}
\title{Creates an Amazon FSx for Lustre data repository task}
\usage{
fsx_create_data_repository_task(Type, Paths, FileSystemId, Report,
  ClientRequestToken, Tags)
}
\arguments{
\item{Type}{[required] Specifies the type of data repository task to create.}

\item{Paths}{(Optional) The path or paths on the Amazon FSx file system to use when
the data repository task is processed. The default path is the file
system root directory.}

\item{FileSystemId}{[required]}

\item{Report}{[required] Defines whether or not Amazon FSx provides a CompletionReport once the
task has completed. A CompletionReport provides a detailed report on the
files that Amazon FSx processed that meet the criteria specified by the
\code{Scope} parameter.}

\item{ClientRequestToken}{}

\item{Tags}{}
}
\description{
Creates an Amazon FSx for Lustre data repository task. You use data
repository tasks to perform bulk operations between your Amazon FSx file
system and its linked data repository. An example of a data repository
task is exporting any data and metadata changes, including POSIX
metadata, to files, directories, and symbolic links (symlinks) from your
FSx file system to its linked data repository. A
\code{CreateDataRepositoryTask} operation will fail if a data repository is
not linked to the FSx file system. To learn more about data repository
tasks, see \href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html}{Using Data Repository Tasks}.
To learn more about linking a data repository to your file system, see
\href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/getting-started-step1.html}{Step 1: Create Your Amazon FSx for Lustre File System}.
}
\section{Request syntax}{
\preformatted{svc$create_data_repository_task(
  Type = "EXPORT_TO_REPOSITORY",
  Paths = list(
    "string"
  ),
  FileSystemId = "string",
  Report = list(
    Enabled = TRUE|FALSE,
    Path = "string",
    Format = "REPORT_CSV_20191124",
    Scope = "FAILED_FILES_ONLY"
  ),
  ClientRequestToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
