% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_volume_initiators}
\alias{storagegateway_list_volume_initiators}
\title{Lists iSCSI initiators that are connected to a volume}
\usage{
storagegateway_list_volume_initiators(VolumeARN)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the volume. Use the
\code{\link[=storagegateway_list_volumes]{list_volumes}} operation to return a list
of gateway volumes for the gateway.}
}
\value{
A list with the following syntax:\preformatted{list(
  Initiators = list(
    "string"
  )
)
}
}
\description{
Lists iSCSI initiators that are connected to a volume. You can use this
operation to determine whether a volume is being used or not. This
operation is only supported in the cached volume and stored volume
gateway types.
}
\section{Request syntax}{
\preformatted{svc$list_volume_initiators(
  VolumeARN = "string"
)
}
}

\keyword{internal}
