% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_data_repository_task}
\alias{fsx_create_data_repository_task}
\title{Creates an Amazon FSx for Lustre data repository task}
\usage{
fsx_create_data_repository_task(Type, Paths, FileSystemId, Report,
  ClientRequestToken, Tags)
}
\arguments{
\item{Type}{[required] Specifies the type of data repository task to create.}

\item{Paths}{(Optional) The path or paths on the Amazon FSx file system to use when
the data repository task is processed. The default path is the file
system root directory. The paths you provide need to be relative to the
mount point of the file system. If the mount point is \verb{/mnt/fsx} and
\verb{/mnt/fsx/path1} is a directory or file on the file system you want to
export, then the path to provide is \code{path1}. If a path that you provide
isn't valid, the task fails.}

\item{FileSystemId}{[required]}

\item{Report}{[required] Defines whether or not Amazon FSx provides a CompletionReport once the
task has completed. A CompletionReport provides a detailed report on the
files that Amazon FSx processed that meet the criteria specified by the
\code{Scope} parameter. For more information, see \href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html}{Working with Task Completion Reports}.}

\item{ClientRequestToken}{}

\item{Tags}{}
}
\value{
A list with the following syntax:\preformatted{list(
  DataRepositoryTask = list(
    TaskId = "string",
    Lifecycle = "PENDING"|"EXECUTING"|"FAILED"|"SUCCEEDED"|"CANCELED"|"CANCELING",
    Type = "EXPORT_TO_REPOSITORY",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    StartTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    ResourceARN = "string",
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    FileSystemId = "string",
    Paths = list(
      "string"
    ),
    FailureDetails = list(
      Message = "string"
    ),
    Status = list(
      TotalCount = 123,
      SucceededCount = 123,
      FailedCount = 123,
      LastUpdatedTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    Report = list(
      Enabled = TRUE|FALSE,
      Path = "string",
      Format = "REPORT_CSV_20191124",
      Scope = "FAILED_FILES_ONLY"
    )
  )
)
}
}
\description{
Creates an Amazon FSx for Lustre data repository task. You use data
repository tasks to perform bulk operations between your Amazon FSx file
system and its linked data repository. An example of a data repository
task is exporting any data and metadata changes, including POSIX
metadata, to files, directories, and symbolic links (symlinks) from your
FSx file system to its linked data repository. A
\code{\link[=fsx_create_data_repository_task]{create_data_repository_task}}
operation will fail if a data repository is not linked to the FSx file
system. To learn more about data repository tasks, see \href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html}{Data Repository Tasks}.
To learn more about linking a data repository to your file system, see
\href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-fs-linked-data-repo.html}{Linking your file system to an S3 bucket}.
}
\section{Request syntax}{
\preformatted{svc$create_data_repository_task(
  Type = "EXPORT_TO_REPOSITORY",
  Paths = list(
    "string"
  ),
  FileSystemId = "string",
  Report = list(
    Enabled = TRUE|FALSE,
    Path = "string",
    Format = "REPORT_CSV_20191124",
    Scope = "FAILED_FILES_ONLY"
  ),
  ClientRequestToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
