% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_create_snapshot_from_volume_recovery_point}
\alias{storagegateway_create_snapshot_from_volume_recovery_point}
\title{Initiates a snapshot of a gateway from a volume recovery point}
\usage{
storagegateway_create_snapshot_from_volume_recovery_point(VolumeARN,
  SnapshotDescription, Tags)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
\code{\link[=storagegateway_describe_storedi_scsi_volumes]{describe_storedi_scsi_volumes}}
operation to return to retrieve the TargetARN for specified VolumeARN.}

\item{SnapshotDescription}{[required] Textual description of the snapshot that appears in the Amazon EC2
console, Elastic Block Store snapshots panel in the \strong{Description}
field, and in the AWS Storage Gateway snapshot \strong{Details} pane,
\strong{Description} field.}

\item{Tags}{A list of up to 50 tags that can be assigned to a snapshot. Each tag is
a key-value pair.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . _ : / @. The maximum length of a tag's key is 128 characters, and
the maximum length for a tag's value is 256.}
}
\value{
A list with the following syntax:\preformatted{list(
  SnapshotId = "string",
  VolumeARN = "string",
  VolumeRecoveryPointTime = "string"
)
}
}
\description{
Initiates a snapshot of a gateway from a volume recovery point. This
operation is only supported in the cached volume gateway type.

A volume recovery point is a point in time at which all data of the
volume is consistent and from which you can create a snapshot. To get a
list of volume recovery point for cached volume gateway, use
\code{\link[=storagegateway_list_volume_recovery_points]{list_volume_recovery_points}}.

In the
\code{\link[=storagegateway_create_snapshot_from_volume_recovery_point]{create_snapshot_from_volume_recovery_point}}
request, you identify the volume by providing its Amazon Resource Name
(ARN). You must also provide a description for the snapshot. When the
gateway takes a snapshot of the specified volume, the snapshot and its
description appear in the AWS Storage Gateway console. In response, the
gateway returns you a snapshot ID. You can use this snapshot ID to check
the snapshot progress or later use it when you want to create a volume
from a snapshot.

To list or delete a snapshot, you must use the Amazon EC2 API. For more
information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html}{DescribeSnapshots}
or
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html}{DeleteSnapshot}
in the \emph{Amazon Elastic Compute Cloud API Reference}.
}
\section{Request syntax}{
\preformatted{svc$create_snapshot_from_volume_recovery_point(
  VolumeARN = "string",
  SnapshotDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Initiates a snapshot of a gateway from a volume recovery point.
svc$create_snapshot_from_volume_recovery_point(
  SnapshotDescription = "My root volume snapshot as of 2017-06-30T10:10:10.000Z",
  VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12..."
)
}

}
\keyword{internal}
