% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_acl}
\alias{s3_get_bucket_acl}
\title{This implementation of the GET operation uses the acl subresource to
return the access control list (ACL) of a bucket}
\usage{
s3_get_bucket_acl(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] Specifies the S3 bucket whose ACL is being requested.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
This implementation of the \code{GET} operation uses the \code{acl} subresource to
return the access control list (ACL) of a bucket. To use \code{GET} to return
the ACL of the bucket, you must have \code{READ_ACP} access to the bucket. If
\code{READ_ACP} permission is granted to the anonymous user, you can return
the ACL of the bucket without using an authorization header.

\strong{Related Resources}
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html}{ListObjects}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_acl(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
