% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_list_parts}
\alias{glacier_list_parts}
\title{This operation lists the parts of an archive that have been uploaded in
a specific multipart upload}
\usage{
glacier_list_parts(accountId, vaultName, uploadId, marker, limit)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{uploadId}{[required] The upload ID of the multipart upload.}

\item{marker}{An opaque string used for pagination. This value specifies the part at
which the listing of parts should begin. Get the marker value from the
response of a previous List Parts response. You need only include the
marker if you are continuing the pagination of results started in a
previous List Parts request.}

\item{limit}{The maximum number of parts to be returned. The default limit is 50. The
number of parts returned might be fewer than the specified limit, but
the number of returned parts never exceeds the limit.}
}
\description{
This operation lists the parts of an archive that have been uploaded in
a specific multipart upload. You can make this request at any time
during an in-progress multipart upload before you complete the upload
(see CompleteMultipartUpload. List Parts returns an error for completed
uploads. The list returned in the List Parts response is sorted by part
range.

The List Parts operation supports pagination. By default, this operation
returns up to 50 uploaded parts in the response. You should always check
the response for a \code{marker} at which to continue the list; if there are
no more items the \code{marker} is \code{null}. To return a list of parts that
begins at a specific part, set the \code{marker} request parameter to the
value you obtained from a previous List Parts request. You can also
limit the number of parts returned in the response by specifying the
\code{limit} parameter in the request.

An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don't have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/auth-and-access-control.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For conceptual information and the underlying REST API, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html}{Working with Archives in Amazon S3 Glacier}
and \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html}{List Parts}
in the \emph{Amazon Glacier Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_parts(
  accountId = "string",
  vaultName = "string",
  uploadId = "string",
  marker = "string",
  limit = "string"
)
}
}

\examples{
\dontrun{
# The example lists all the parts of a multipart upload.
svc$list_parts(
  accountId = "-",
  uploadId = "OW2fM5iVylEpFEMM9_HpKowRapC3vn5sSL39_396UW9zLFUWVrnRHaPjUJddQ5OxSHVXjYtrN47NBZ...",
  vaultName = "examplevault"
)
}

}
\keyword{internal}
