% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_copy_job}
\alias{backup_start_copy_job}
\title{Starts a job to create a one-time copy of the specified resource}
\usage{
backup_start_copy_job(RecoveryPointArn, SourceBackupVaultName,
  DestinationBackupVaultArn, IamRoleArn, IdempotencyToken, Lifecycle)
}
\arguments{
\item{RecoveryPointArn}{[required] An ARN that uniquely identifies a recovery point to use for the copy
job; for example,
arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.}

\item{SourceBackupVaultName}{[required] The name of a logical source container where backups are stored. Backup
vaults are identified by names that are unique to the account used to
create them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{DestinationBackupVaultArn}{[required] An Amazon Resource Name (ARN) that uniquely identifies a destination
backup vault to copy to; for example,
\code{arn:aws:backup:us-east-1:123456789012:vault:aBackupVault}.}

\item{IamRoleArn}{[required] Specifies the IAM role ARN used to copy the target recovery point; for
example, \verb{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer chosen string that can be used to distinguish between calls
to \code{StartCopyJob}.}

\item{Lifecycle}{}
}
\description{
Starts a job to create a one-time copy of the specified resource.
}
\section{Request syntax}{
\preformatted{svc$start_copy_job(
  RecoveryPointArn = "string",
  SourceBackupVaultName = "string",
  DestinationBackupVaultArn = "string",
  IamRoleArn = "string",
  IdempotencyToken = "string",
  Lifecycle = list(
    MoveToColdStorageAfterDays = 123,
    DeleteAfterDays = 123
  )
)
}
}

\keyword{internal}
