% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_refresh_cache}
\alias{storagegateway_refresh_cache}
\title{Refreshes the cache for the specified file share}
\usage{
storagegateway_refresh_cache(FileShareARN, FolderList, Recursive)
}
\arguments{
\item{FileShareARN}{[required] The Amazon Resource Name (ARN) of the file share you want to refresh.}

\item{FolderList}{A comma-separated list of the paths of folders to refresh in the cache.
The default is [\code{"/"}]. The default refreshes objects and folders at
the root of the Amazon S3 bucket. If \code{Recursive} is set to "true", the
entire S3 bucket that the file share has access to is refreshed.}

\item{Recursive}{A value that specifies whether to recursively refresh folders in the
cache. The refresh includes folders that were in the cache the last time
the gateway listed the folder's contents. If this value set to
"true", each folder that is listed in \code{FolderList} is recursively
updated. Otherwise, subfolders listed in \code{FolderList} are not refreshed.
Only objects that are in folders listed directly under \code{FolderList} are
found and used for the update. The default is "true".}
}
\description{
Refreshes the cache for the specified file share. This operation finds
objects in the Amazon S3 bucket that were added, removed or replaced
since the gateway last listed the bucket's contents and cached the
results. This operation is only supported in the file gateway type. You
can subscribe to be notified through an Amazon CloudWatch event when
your RefreshCache operation completes. For more information, see
\href{https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification}{Getting Notified About File Operations}.
}
\section{Request syntax}{
\preformatted{svc$refresh_cache(
  FileShareARN = "string",
  FolderList = list(
    "string"
  ),
  Recursive = TRUE|FALSE
)
}
}

\keyword{internal}
