% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_object}
\alias{s3_delete_object}
\title{Removes the null version (if there is one) of an object and inserts a
delete marker, which becomes the latest version of the object}
\usage{
s3_delete_object(Bucket, Key, MFA, VersionId, RequestPayer,
  BypassGovernanceRetention)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{MFA}{The concatenation of the authentication device's serial number, a
space, and the value that is displayed on your authentication device.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{RequestPayer}{}

\item{BypassGovernanceRetention}{Indicates whether S3 Object Lock should bypass Governance-mode
restrictions to process this operation.}
}
\description{
Removes the null version (if there is one) of an object and inserts a
delete marker, which becomes the latest version of the object. If there
isn't a null version, Amazon S3 does not remove any objects.
}
\section{Request syntax}{
\preformatted{svc$delete_object(
  Bucket = "string",
  Key = "string",
  MFA = "string",
  VersionId = "string",
  RequestPayer = "requester",
  BypassGovernanceRetention = TRUE|FALSE
)
}
}

\examples{
# The following example deletes an object from a non-versioned bucket.
\donttest{svc$delete_object(
  Bucket = "ExampleBucket",
  Key = "HappyFace.jpg"
)}

# The following example deletes an object from an S3 bucket.
\donttest{svc$delete_object(
  Bucket = "examplebucket",
  Key = "objectkey.jpg"
)}

}
\keyword{internal}
