# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS S3 Control
#'
#' @description
#' AWS S3 Control provides access to Amazon S3 control plane operations.
#'
#' @examples
#' \donttest{svc <- s3control()
#' svc$delete_public_access_block(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=s3control_delete_public_access_block]{delete_public_access_block} \tab Removes the Public Access Block configuration for an Amazon Web Services account \cr
#'  \link[=s3control_get_public_access_block]{get_public_access_block} \tab Retrieves the Public Access Block configuration for an Amazon Web Services account \cr
#'  \link[=s3control_put_public_access_block]{put_public_access_block} \tab Creates or modifies the Public Access Block configuration for an Amazon Web Services account
#' }
#'
#' @rdname s3control
#' @export
s3control <- function() {
  .s3control$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.s3control <- list()

.s3control$operations <- list()

.s3control$metadata <- list(
  service_name = "s3control",
  endpoints = list("*" = "s3control.{region}.amazonaws.com", "cn-*" = "s3control.{region}.amazonaws.com.cn"),
  service_id = "S3 Control",
  api_version = "2018-08-20",
  signing_name = "s3",
  json_version = "",
  target_prefix = ""
)

.s3control$handlers <- new_handlers("restxml", "s3v4")

.s3control$service <- function() {
  new_service(.s3control$metadata, .s3control$handlers)
}
