% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_role_with_saml}
\alias{sts_assume_role_with_saml}
\title{Returns a set of temporary security credentials for users who have been
authenticated via a SAML authentication response}
\usage{
sts_assume_role_with_saml(
  RoleArn,
  PrincipalArn,
  SAMLAssertion,
  PolicyArns = NULL,
  Policy = NULL,
  DurationSeconds = NULL
)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role that the caller is assuming.}

\item{PrincipalArn}{[required] The Amazon Resource Name (ARN) of the SAML provider in IAM that
describes the IdP.}

\item{SAMLAssertion}{[required] The base64 encoded SAML authentication response provided by the IdP.

For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml_relying-party.html}{Configuring a Relying Party and Adding Claims}
in the \emph{IAM User Guide}.}

\item{PolicyArns}{The Amazon Resource Names (ARNs) of the IAM managed policies that you
want to use as managed session policies. The policies must exist in the
same account as the role.

This parameter is optional. You can provide up to 10 managed policy
ARNs. However, the plaintext that you use for both inline and managed
session policies can't exceed 2,048 characters. For more information
about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}
in the Amazon Web Services General Reference.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.

Passing policies to this operation returns new temporary credentials.
The resulting session's permissions are the intersection of the role's
identity-based policy and the session policies. You can use the role's
temporary credentials in subsequent Amazon Web Services API calls to
access resources in the account that owns the role. You cannot use
session policies to grant more permissions than those allowed by the
identity-based policy of the role that is being assumed. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.}

\item{Policy}{An IAM policy in JSON format that you want to use as an inline session
policy.

This parameter is optional. Passing policies to this operation returns
new temporary credentials. The resulting session's permissions are the
intersection of the role's identity-based policy and the session
policies. You can use the role's temporary credentials in subsequent
Amazon Web Services API calls to access resources in the account that
owns the role. You cannot use session policies to grant more permissions
than those allowed by the identity-based policy of the role that is
being assumed. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The plaintext that you use for both inline and managed session policies
can't exceed 2,048 characters. The JSON policy characters can be any
ASCII character from the space character to the end of the valid
character list (\code{U+0020} through \verb{U+00FF}). It can also include the tab
(\code{U+0009}), linefeed (\verb{U+000A}), and carriage return (\verb{U+000D}) characters.

For more information about role session permissions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session policies}.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.}

\item{DurationSeconds}{The duration, in seconds, of the role session. Your role session lasts
for the duration that you specify for the \code{DurationSeconds} parameter,
or until the time specified in the SAML authentication response's
\code{SessionNotOnOrAfter} value, whichever is shorter. You can provide a
\code{DurationSeconds} value from 900 seconds (15 minutes) up to the maximum
session duration setting for the role. This setting can have a value
from 1 hour to 12 hours. If you specify a value higher than this
setting, the operation fails. For example, if you specify a session
duration of 12 hours, but your administrator set the maximum session
duration to 6 hours, your operation fails. To learn how to view the
maximum value for your role, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}.

By default, the value is set to \code{3600} seconds.

The \code{DurationSeconds} parameter is separate from the duration of a
console session that you might request using the returned credentials.
The request to the federation endpoint for a console sign-in token takes
a \code{SessionDuration} parameter that specifies the maximum length of the
console session. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html}{Creating a URL that Enables Federated Users to Access the Amazon Web Services Management Console}
in the \emph{IAM User Guide}.}
}
\description{
Returns a set of temporary security credentials for users who have been authenticated via a SAML authentication response. This operation provides a mechanism for tying an enterprise identity store or directory to role-based Amazon Web Services access without user-specific credentials or configuration. For a comparison of \code{\link[=sts_assume_role_with_saml]{assume_role_with_saml}} with the other API operations that produce temporary credentials, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials} and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_sts-comparison.html}{Compare STS credentials} in the \emph{IAM User Guide}.

See \url{https://www.paws-r-sdk.com/docs/sts_assume_role_with_saml/} for full documentation.
}
\keyword{internal}
