% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssoadmin_operations.R
\name{ssoadmin_create_instance}
\alias{ssoadmin_create_instance}
\title{Creates an instance of IAM Identity Center for a standalone Amazon Web
Services account that is not managed by Organizations or a member Amazon
Web Services account in an organization}
\usage{
ssoadmin_create_instance(ClientToken = NULL, Name = NULL, Tags = NULL)
}
\arguments{
\item{ClientToken}{Specifies a unique, case-sensitive ID that you provide to ensure the
idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}

\item{Name}{The name of the instance of IAM Identity Center.}

\item{Tags}{Specifies tags to be attached to the instance of IAM Identity Center.}
}
\description{
Creates an instance of IAM Identity Center for a standalone Amazon Web Services account that is not managed by Organizations or a member Amazon Web Services account in an organization. You can create only one instance per account and across all Amazon Web Services Regions.

See \url{https://www.paws-r-sdk.com/docs/ssoadmin_create_instance/} for full documentation.
}
\keyword{internal}
