# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Account
#'
#' @description
#' Operations for Amazon Web Services Account Management
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- account(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- account()
#' svc$delete_alternate_contact(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=account_delete_alternate_contact]{delete_alternate_contact} \tab Deletes the specified alternate contact from an Amazon Web Services account\cr
#'  \link[=account_disable_region]{disable_region} \tab Disables (opts-out) a particular Region for an account\cr
#'  \link[=account_enable_region]{enable_region} \tab Enables (opts-in) a particular Region for an account\cr
#'  \link[=account_get_alternate_contact]{get_alternate_contact} \tab Retrieves the specified alternate contact attached to an Amazon Web Services account\cr
#'  \link[=account_get_contact_information]{get_contact_information} \tab Retrieves the primary contact information of an Amazon Web Services account\cr
#'  \link[=account_get_region_opt_status]{get_region_opt_status} \tab Retrieves the opt-in status of a particular Region\cr
#'  \link[=account_list_regions]{list_regions} \tab Lists all the Regions for a given account and their respective opt-in statuses\cr
#'  \link[=account_put_alternate_contact]{put_alternate_contact} \tab Modifies the specified alternate contact attached to an Amazon Web Services account\cr
#'  \link[=account_put_contact_information]{put_contact_information} \tab Updates the primary contact information of an Amazon Web Services account
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname account
#' @export
account <- function(config = list()) {
  svc <- .account$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.account <- list()

.account$operations <- list()

.account$metadata <- list(
  service_name = "account",
  endpoints = list("*" = list(endpoint = "account.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "account.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "account.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "account.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Account",
  api_version = "2021-02-01",
  signing_name = "account",
  json_version = "1.1",
  target_prefix = ""
)

.account$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.account$metadata, handlers, config)
}
