% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_list_secrets}
\alias{secretsmanager_list_secrets}
\title{Lists the secrets that are stored by Secrets Manager in the Amazon Web
Services account, not including secrets that are marked for deletion}
\usage{
secretsmanager_list_secrets(
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{MaxResults}{The number of results to include in the response.

If there are more results available, in the response, Secrets Manager
includes \code{NextToken}. To get the next results, call
\code{\link[=secretsmanager_list_secrets]{list_secrets}} again with the value from
\code{NextToken}.}

\item{NextToken}{A token that indicates where the output should continue from, if a
previous call did not show all results. To get the next results, call
\code{\link[=secretsmanager_list_secrets]{list_secrets}} again with this value.}

\item{Filters}{The filters to apply to the list of secrets.}

\item{SortOrder}{Lists secrets in the requested order.}
}
\description{
Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account, not including secrets that are marked for deletion. To see secrets marked for deletion, use the Secrets Manager console.

See \url{https://paws-r.github.io/docs/secretsmanager/list_secrets.html} for full documentation.
}
\keyword{internal}
