% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_sign}
\alias{kms_sign}
\title{Creates a digital signature for a message or message digest by using the
private key in an asymmetric signing KMS key}
\usage{
kms_sign(
  KeyId,
  Message,
  MessageType = NULL,
  GrantTokens = NULL,
  SigningAlgorithm
)
}
\arguments{
\item{KeyId}{[required] Identifies an asymmetric KMS key. KMS uses the private key in the
asymmetric KMS key to sign the message. The \code{KeyUsage} type of the KMS
key must be \code{SIGN_VERIFY}. To find the \code{KeyUsage} of a KMS key, use the
\code{\link[=kms_describe_key]{describe_key}} operation.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{Message}{[required] Specifies the message or message digest to sign. Messages can be 0-4096
bytes. To sign a larger message, provide the message digest.

If you provide a message, KMS generates a hash digest of the message and
then signs it.}

\item{MessageType}{Tells KMS whether the value of the \code{Message} parameter is a message or
message digest. The default value, RAW, indicates a message. To indicate
a message digest, enter \code{DIGEST}.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}

\item{SigningAlgorithm}{[required] Specifies the signing algorithm to use when signing the message.

Choose an algorithm that is compatible with the type and size of the
specified asymmetric KMS key.}
}
\description{
Creates a \href{https://en.wikipedia.org/wiki/Digital_signature}{digital signature} for a message or message digest by using the private key in an asymmetric signing KMS key. To verify the signature, use the \code{\link[=kms_verify]{verify}} operation, or use the public key in the same asymmetric KMS key outside of KMS. For information about asymmetric KMS keys, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Asymmetric KMS keys} in the \emph{Key Management Service Developer Guide}.

See \url{https://paws-r.github.io/docs/kms/sign.html} for full documentation.
}
\keyword{internal}
