% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_confirm_sign_up}
\alias{cognitoidentityprovider_confirm_sign_up}
\title{Confirms registration of a new user}
\usage{
cognitoidentityprovider_confirm_sign_up(
  ClientId,
  SecretHash = NULL,
  Username,
  ConfirmationCode,
  ForceAliasCreation = NULL,
  AnalyticsMetadata = NULL,
  UserContextData = NULL,
  ClientMetadata = NULL
)
}
\arguments{
\item{ClientId}{[required] The ID of the app client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The user name of the user whose registration you want to confirm.}

\item{ConfirmationCode}{[required] The confirmation code sent by a user's request to confirm registration.}

\item{ForceAliasCreation}{Boolean to be specified to force user confirmation irrespective of
existing alias. By default set to \code{False}. If this parameter is set to
\code{True} and the phone number/email used for sign up confirmation already
exists as an alias with a different user, the API call will migrate the
alias from the previous user to the newly created user being confirmed.
If set to \code{False}, the API will throw an \strong{AliasExistsException} error.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{\link[=cognitoidentityprovider_confirm_sign_up]{confirm_sign_up}} calls.}

\item{UserContextData}{Contextual data about your user session, such as the device fingerprint,
IP address, or location. Amazon Cognito advanced security evaluates the
risk of an authentication event based on the context that your app
generates and passes to Amazon Cognito when it makes API requests.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the ConfirmSignUp API action, Amazon Cognito
invokes the function that is assigned to the \emph{post confirmation}
trigger. When Amazon Cognito invokes this function, it passes a JSON
payload, which the function receives as input. This payload contains a
\code{clientMetadata} attribute, which provides the data that you assigned to
the ClientMetadata parameter in your ConfirmSignUp request. In your
function code in Lambda, you can process the \code{clientMetadata} value to
enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}
}
\description{
Confirms registration of a new user.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/confirm_sign_up.html} for full documentation.
}
\keyword{internal}
