% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_user}
\alias{iam_delete_user}
\title{Deletes the specified IAM user}
\usage{
iam_delete_user(UserName)
}
\arguments{
\item{UserName}{[required] The name of the user to delete.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}
}
\description{
Deletes the specified IAM user. Unlike the AWS Management Console, when
you delete a user programmatically, you must delete the items attached
to the user manually, or the deletion fails. For more information, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli}{Deleting an IAM User}.
Before attempting to delete a user, remove the following items:
}
\details{
\itemize{
\item Password (DeleteLoginProfile)
\item Access keys (DeleteAccessKey)
\item Signing certificate (DeleteSigningCertificate)
\item SSH public key (DeleteSSHPublicKey)
\item Git credentials (DeleteServiceSpecificCredential)
\item Multi-factor authentication (MFA) device (DeactivateMFADevice,
DeleteVirtualMFADevice)
\item Inline policies (DeleteUserPolicy)
\item Attached managed policies (DetachUserPolicy)
\item Group memberships (RemoveUserFromGroup)
}
}
\section{Request syntax}{
\preformatted{svc$delete_user(
  UserName = "string"
)
}
}

\examples{
# The following command removes the IAM user named Bob from the current
# account.
\donttest{svc$delete_user(
  UserName = "Bob"
)}

}
\keyword{internal}
