% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_update_secret}
\alias{secretsmanager_update_secret}
\title{Modifies many of the details of the specified secret}
\usage{
secretsmanager_update_secret(SecretId, ClientRequestToken, Description,
  KmsKeyId, SecretBinary, SecretString)
}
\arguments{
\item{SecretId}{[required] Specifies the secret that you want to modify or to which you want to add
a new version. You can specify either the Amazon Resource Name (ARN) or
the friendly name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}

\item{ClientRequestToken}{(Optional) If you want to add a new version to the secret, this
parameter specifies a unique identifier for the new version that helps
ensure idempotency.

If you use the AWS CLI or one of the AWS SDK to call this operation,
then you can leave this parameter empty. The CLI or SDK generates a
random UUID for you and includes that in the request. If you don't use
the SDK and instead generate a raw HTTP request to the Secrets Manager
service endpoint, then you must generate a \code{ClientRequestToken} yourself
for new versions and include that value in the request.

You typically only need to interact with this value if you implement
your own retry logic and want to ensure that a given secret is not
created twice. We recommend that you generate a
\href{https://wikipedia.org/wiki/Universally_unique_identifier}{UUID-type}
value to ensure uniqueness within the specified secret.

Secrets Manager uses this value to prevent the accidental creation of
duplicate versions if there are failures and retries during the Lambda
rotation function's processing.
\itemize{
\item If the \code{ClientRequestToken} value isn't already associated with a
version of the secret then a new version of the secret is created.
\item If a version with this value already exists and that version's
\code{SecretString} and \code{SecretBinary} values are the same as those in
the request then the request is ignored (the operation is
idempotent).
\item If a version with this value already exists and that version's
\code{SecretString} and \code{SecretBinary} values are different from the
request then an error occurs because you cannot modify an existing
secret value.
}

This value becomes the \code{VersionId} of the new version.}

\item{Description}{(Optional) Specifies an updated user-provided description of the secret.}

\item{KmsKeyId}{(Optional) Specifies an updated ARN or alias of the AWS KMS customer
master key (CMK) to be used to encrypt the protected text in new
versions of this secret.

You can only use the account's default CMK to encrypt and decrypt if
you call this operation using credentials from the same account that
owns the secret. If the secret is in a different account, then you must
create a custom CMK and provide the ARN of that CMK in this field. The
user making the call must have permissions to both the secret and the
CMK in their respective accounts.}

\item{SecretBinary}{(Optional) Specifies updated binary data that you want to encrypt and
store in the new version of the secret. To use this parameter in the
command-line tools, we recommend that you store your binary data in a
file and then use the appropriate technique for your tool to pass the
contents of the file as a parameter. Either \code{SecretBinary} or
\code{SecretString} must have a value, but not both. They cannot both be
empty.

This parameter is not accessible using the Secrets Manager console.}

\item{SecretString}{(Optional) Specifies updated text data that you want to encrypt and
store in this new version of the secret. Either \code{SecretBinary} or
\code{SecretString} must have a value, but not both. They cannot both be
empty.

If you create this secret by using the Secrets Manager console then
Secrets Manager puts the protected secret text in only the
\code{SecretString} parameter. The Secrets Manager console stores the
information as a JSON structure of key/value pairs that the default
Lambda rotation function knows how to parse.

For storing multiple values, we recommend that you use a JSON text
string argument and specify key/value pairs. For information on how to
format a JSON parameter for the various command line tool environments,
see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json}{Using JSON for Parameters}
in the \emph{AWS CLI User Guide}. For example:

\code{\\[\{"username":"bob"\},\{"password":"abc123xyz456"\}\\]}

If your command-line tool or SDK requires quotation marks around the
parameter, you should use single quotes to avoid confusion with the
double quotes required in the JSON text. You can also 'escape' the
double quote character in the embedded JSON text by prefacing each with
a backslash. For example, the following string is surrounded by
double-quotes. All of the embedded double quotes are escaped:

\code{"\\[\{\"username\":\"bob\"\},\{\"password\":\"abc123xyz456\"\}\\]"}}
}
\description{
Modifies many of the details of the specified secret. If you include a
\code{ClientRequestToken} and \emph{either} \code{SecretString} or \code{SecretBinary} then
it also creates a new version attached to the secret.
}
\details{
To modify the rotation configuration of a secret, use RotateSecret
instead.

The Secrets Manager console uses only the \code{SecretString} parameter and
therefore limits you to encrypting and storing only a text string. To
encrypt and store binary data as part of the version of a secret, you
must use either the AWS CLI or one of the AWS SDKs.
\itemize{
\item If a version with a \code{VersionId} with the same value as the
\code{ClientRequestToken} parameter already exists, the operation results
in an error. You cannot modify an existing version, you can only
create a new version.
\item If you include \code{SecretString} or \code{SecretBinary} to create a new
secret version, Secrets Manager automatically attaches the staging
label \code{AWSCURRENT} to the new version.
}<!-- -->

\itemize{
\item If you call an operation that needs to encrypt or decrypt the
\code{SecretString} or \code{SecretBinary} for a secret in the same account as
the calling user and that secret doesn't specify a AWS KMS
encryption key, Secrets Manager uses the account's default AWS
managed customer master key (CMK) with the alias
\code{aws/secretsmanager}. If this key doesn't already exist in your
account then Secrets Manager creates it for you automatically. All
users and roles in the same AWS account automatically have access to
use the default CMK. Note that if an Secrets Manager API call
results in AWS having to create the account's AWS-managed CMK, it
can result in a one-time significant delay in returning the result.
\item If the secret is in a different AWS account from the credentials
calling an API that requires encryption or decryption of the secret
value then you must create and use a custom AWS KMS CMK because you
can't access the default CMK for the account using credentials from
a different AWS account. Store the ARN of the CMK in the secret when
you create the secret or when you update it by including it in the
\code{KMSKeyId}. If you call an API that must encrypt or decrypt
\code{SecretString} or \code{SecretBinary} using credentials from a different
account then the AWS KMS key policy must grant cross-account access
to that other account's user or role for both the
kms:GenerateDataKey and kms:Decrypt operations.
}

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:UpdateSecret
\item kms:GenerateDataKey - needed only if you use a custom AWS KMS key to
encrypt the secret. You do not need this permission to use the
account's AWS managed CMK for Secrets Manager.
\item kms:Decrypt - needed only if you use a custom AWS KMS key to encrypt
the secret. You do not need this permission to use the account's
AWS managed CMK for Secrets Manager.
}

\strong{Related operations}
\itemize{
\item To create a new secret, use CreateSecret.
\item To add only a new version to an existing secret, use PutSecretValue.
\item To get the details for a secret, use DescribeSecret.
\item To list the versions contained in a secret, use
ListSecretVersionIds.
}
}
\section{Request syntax}{
\preformatted{svc$update_secret(
  SecretId = "string",
  ClientRequestToken = "string",
  Description = "string",
  KmsKeyId = "string",
  SecretBinary = raw,
  SecretString = "string"
)
}
}

\examples{
# The following example shows how to modify the description of a secret.
\donttest{svc$update_secret(
  ClientRequestToken = "EXAMPLE1-90ab-cdef-fedc-ba987EXAMPLE",
  Description = "This is a new description for the secret.",
  SecretId = "MyTestDatabaseSecret"
)}

# This example shows how to update the KMS customer managed key (CMK) used
# to encrypt the secret value. The KMS CMK must be in the same region as
# the secret.
\donttest{svc$update_secret(
  KmsKeyId = "arn:aws:kms:us-west-2:123456789012:key/EXAMPLE2-90ab-cdef-fedc-ba987EXAMPLE",
  SecretId = "MyTestDatabaseSecret"
)}

# The following example shows how to create a new version of the secret by
# updating the SecretString field. Alternatively, you can use the
# put-secret-value operation.
\donttest{svc$update_secret(
  SecretId = "MyTestDatabaseSecret",
  SecretString = "{JSON STRING WITH CREDENTIALS}"
)}

}
\keyword{internal}
