% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_operations.R
\name{cognitosync_update_records}
\alias{cognitosync_update_records}
\title{Posts updates to records and adds and deletes records for a dataset and
user}
\usage{
cognitosync_update_records(IdentityPoolId, IdentityId, DatasetName,
  DeviceId, RecordPatches, SyncSessionToken, ClientContext)
}
\arguments{
\item{IdentityPoolId}{[required] A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. GUID generation is unique within a region.}

\item{IdentityId}{[required] A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. GUID generation is unique within a region.}

\item{DatasetName}{[required] A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
'_' (underscore), '-' (dash), and '.' (dot).}

\item{DeviceId}{The unique ID generated for this device by Cognito.}

\item{RecordPatches}{A list of patch operations.}

\item{SyncSessionToken}{[required] The SyncSessionToken returned by a previous call to ListRecords for this
dataset and identity.}

\item{ClientContext}{Intended to supply a device ID that will populate the lastModifiedBy
field referenced in other methods. The ClientContext field is not yet
implemented.}
}
\value{
A list with the following syntax:\preformatted{list(
  Records = list(
    list(
      Key = "string",
      Value = "string",
      SyncCount = 123,
      LastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedBy = "string",
      DeviceLastModifiedDate = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}
\description{
Posts updates to records and adds and deletes records for a dataset and
user.

The sync count in the record patch is your last known sync count for
that record. The server will reject an UpdateRecords request with a
ResourceConflictException if you try to patch a record with a new value
but a stale sync count.

For example, if the sync count on the server is 5 for a key called
highScore and you try and submit a new highScore with sync count of 4,
the request will be rejected. To obtain the current sync count for a
record, call ListRecords. On a successful update of the record, the
response returns the new sync count for that record. You should present
that sync count the next time you try to update that same record. When
the record does not exist, specify the sync count as 0.

This API can be called with temporary user credentials provided by
Cognito Identity or with developer credentials.
}
\section{Request syntax}{
\preformatted{svc$update_records(
  IdentityPoolId = "string",
  IdentityId = "string",
  DatasetName = "string",
  DeviceId = "string",
  RecordPatches = list(
    list(
      Op = "replace"|"remove",
      Key = "string",
      Value = "string",
      SyncCount = 123,
      DeviceLastModifiedDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  SyncSessionToken = "string",
  ClientContext = "string"
)
}
}

\keyword{internal}
