% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_describe_standards_controls}
\alias{securityhub_describe_standards_controls}
\title{Returns a list of security standards controls}
\usage{
securityhub_describe_standards_controls(StandardsSubscriptionArn,
  NextToken, MaxResults)
}
\arguments{
\item{StandardsSubscriptionArn}{[required] The ARN of a resource that represents your subscription to a supported
standard. To get the subscription ARNs of the standards you have
enabled, use the \verb{<a>GetEnabledStandards</a>} operation.}

\item{NextToken}{The token that is required for pagination. On your first call to the
\code{DescribeStandardsControls} operation, set the value of this parameter
to \code{NULL}.

For subsequent calls to the operation, to continue listing data, set the
value of this parameter to the value returned from the previous
response.}

\item{MaxResults}{The maximum number of security standard controls to return.}
}
\description{
Returns a list of security standards controls.

For each control, the results include information about whether it is
currently enabled, the severity, and a link to remediation information.
}
\section{Request syntax}{
\preformatted{svc$describe_standards_controls(
  StandardsSubscriptionArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
