% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_create_members}
\alias{securityhub_create_members}
\title{Creates a member association in Security Hub between the specified
accounts and the account used to make the request, which is the master
account}
\usage{
securityhub_create_members(AccountDetails)
}
\arguments{
\item{AccountDetails}{[required] The list of accounts to associate with the Security Hub master account.
For each account, the list includes the account ID and optionally the
email address.}
}
\description{
Creates a member association in Security Hub between the specified
accounts and the account used to make the request, which is the master
account. If you are integrated with Organizations, then the master
account is the Security Hub administrator account that is designated by
the organization management account.

\code{CreateMembers} is always used to add accounts that are not organization
members.

For accounts that are part of an organization, \code{CreateMembers} is only
used in the following cases:
\itemize{
\item Security Hub is not configured to automatically add new accounts in
an organization.
\item The account was disassociated or deleted in Security Hub.
}

This action can only be used by an account that has Security Hub
enabled. To enable Security Hub, you can use the
\verb{<a>EnableSecurityHub</a>} operation.

For accounts that are not organization members, you create the account
association and then send an invitation to the member account. To send
the invitation, you use the \verb{<a>InviteMembers</a>} operation. If the
account owner accepts the invitation, the account becomes a member
account in Security Hub.

Accounts that are part of an organization do not receive an invitation.
They automatically become a member account in Security Hub.

A permissions policy is added that permits the master account to view
the findings generated in the member account. When Security Hub is
enabled in a member account, findings are sent to both the member and
master accounts.

To remove the association between the master and member accounts, use
the \verb{<a>DisassociateFromMasterAccount</a>} or
\verb{<a>DisassociateMembers</a>} operation.
}
\section{Request syntax}{
\preformatted{svc$create_members(
  AccountDetails = list(
    list(
      AccountId = "string",
      Email = "string"
    )
  )
)
}
}

\keyword{internal}
