% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_policies_granting_service_access}
\alias{iam_list_policies_granting_service_access}
\title{Retrieves a list of policies that the IAM identity (user, group, or
role) can use to access each specified service}
\usage{
iam_list_policies_granting_service_access(Marker, Arn,
  ServiceNamespaces)
}
\arguments{
\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{Arn}{[required] The ARN of the IAM identity (user, group, or role) whose policies you
want to list.}

\item{ServiceNamespaces}{[required] The service namespace for the AWS services whose policies you want to
list.

To learn the service namespace for a service, go to \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html}{Actions, Resources, and Condition Keys for AWS Services}
in the \emph{IAM User Guide}. Choose the name of the service to view details
for that service. In the first paragraph, find the service prefix. For
example, \code{(service prefix: a4b)}. For more information about service
namespaces, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces}{AWS Service Namespaces}
in theÂ \emph{AWS General Reference}.}
}
\description{
Retrieves a list of policies that the IAM identity (user, group, or
role) can use to access each specified service.
}
\details{
This operation does not use other policy types when determining whether
a resource could access a service. These other policy types include
resource-based policies, access control lists, AWS Organizations
policies, IAM permissions boundaries, and AWS STS assume role policies.
It only applies permissions policy logic. For more about the evaluation
of policy types, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics}{Evaluating Policies}
in the \emph{IAM User Guide}.

The list of policies returned by the operation depends on the ARN of the
identity that you provide.
\itemize{
\item \strong{User} -- The list of policies includes the managed and inline
policies that are attached to the user directly. The list also
includes any additional managed and inline policies that are
attached to the group to which the user belongs.
\item \strong{Group} -- The list of policies includes only the managed and
inline policies that are attached to the group directly. Policies
that are attached to the group's user are not included.
\item \strong{Role} -- The list of policies includes only the managed and
inline policies that are attached to the role.
}

For each managed policy, this operation returns the ARN and policy name.
For each inline policy, it returns the policy name and the entity to
which it is attached. Inline policies do not have an ARN. For more
information about these policy types, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.

Policies that are attached to users and roles as permissions boundaries
are not returned. To view which managed policy is currently used to set
the permissions boundary for a user or role, use the GetUser or GetRole
operations.
}
\section{Request syntax}{
\preformatted{svc$list_policies_granting_service_access(
  Marker = "string",
  Arn = "string",
  ServiceNamespaces = list(
    "string"
  )
)
}
}

\examples{
# The following operation lists policies that allow ExampleUser01 to
# access IAM or EC2.
\donttest{svc$list_policies_granting_service_access(
  Arn = "arn:aws:iam::123456789012:user/ExampleUser01",
  ServiceNamespaces = list(
    "iam",
    "ec2"
  )
)}

}
\keyword{internal}
