% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_pool}
\alias{cognitoidentityprovider_update_user_pool}
\title{Updates the specified user pool with the specified attributes}
\usage{
cognitoidentityprovider_update_user_pool(UserPoolId, Policies,
  LambdaConfig, AutoVerifiedAttributes, SmsVerificationMessage,
  EmailVerificationMessage, EmailVerificationSubject,
  VerificationMessageTemplate, SmsAuthenticationMessage, MfaConfiguration,
  DeviceConfiguration, EmailConfiguration, SmsConfiguration, UserPoolTags,
  AdminCreateUserConfig, UserPoolAddOns)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool you want to update.}

\item{Policies}{A container with the policies you wish to update in a user pool.}

\item{LambdaConfig}{The AWS Lambda configuration information from the request to update the
user pool.}

\item{AutoVerifiedAttributes}{The attributes that are automatically verified when the Amazon Cognito
service makes a request to update user pools.}

\item{SmsVerificationMessage}{A container with information about the SMS verification message.}

\item{EmailVerificationMessage}{The contents of the email verification message.}

\item{EmailVerificationSubject}{The subject of the email verification message.}

\item{VerificationMessageTemplate}{The template for verification messages.}

\item{SmsAuthenticationMessage}{The contents of the SMS authentication message.}

\item{MfaConfiguration}{Can be one of the following values:
\itemize{
\item \code{OFF} - MFA tokens are not required and cannot be specified during
user registration.
\item \code{ON} - MFA tokens are required for all user registrations. You can
only specify required when you are initially creating a user pool.
\item \code{OPTIONAL} - Users have the option when registering to create an MFA
token.
}}

\item{DeviceConfiguration}{Device configuration.}

\item{EmailConfiguration}{Email configuration.}

\item{SmsConfiguration}{SMS configuration.}

\item{UserPoolTags}{The tag keys and values to assign to the user pool. A tag is a label
that you can use to categorize and manage user pools in different ways,
such as by purpose, owner, environment, or other criteria.}

\item{AdminCreateUserConfig}{The configuration for \code{AdminCreateUser} requests.}

\item{UserPoolAddOns}{Used to enable advanced security risk detection. Set the key
\code{AdvancedSecurityMode} to the value "AUDIT".}
}
\description{
Updates the specified user pool with the specified attributes. If you
don't provide a value for an attribute, it will be set to the default
value. You can get a list of the current user pool settings with .
}
\section{Request syntax}{
\preformatted{svc$update_user_pool(
  UserPoolId = "string",
  Policies = list(
    PasswordPolicy = list(
      MinimumLength = 123,
      RequireUppercase = TRUE|FALSE,
      RequireLowercase = TRUE|FALSE,
      RequireNumbers = TRUE|FALSE,
      RequireSymbols = TRUE|FALSE
    )
  ),
  LambdaConfig = list(
    PreSignUp = "string",
    CustomMessage = "string",
    PostConfirmation = "string",
    PreAuthentication = "string",
    PostAuthentication = "string",
    DefineAuthChallenge = "string",
    CreateAuthChallenge = "string",
    VerifyAuthChallengeResponse = "string",
    PreTokenGeneration = "string",
    UserMigration = "string"
  ),
  AutoVerifiedAttributes = list(
    "phone_number"|"email"
  ),
  SmsVerificationMessage = "string",
  EmailVerificationMessage = "string",
  EmailVerificationSubject = "string",
  VerificationMessageTemplate = list(
    SmsMessage = "string",
    EmailMessage = "string",
    EmailSubject = "string",
    EmailMessageByLink = "string",
    EmailSubjectByLink = "string",
    DefaultEmailOption = "CONFIRM_WITH_LINK"|"CONFIRM_WITH_CODE"
  ),
  SmsAuthenticationMessage = "string",
  MfaConfiguration = "OFF"|"ON"|"OPTIONAL",
  DeviceConfiguration = list(
    ChallengeRequiredOnNewDevice = TRUE|FALSE,
    DeviceOnlyRememberedOnUserPrompt = TRUE|FALSE
  ),
  EmailConfiguration = list(
    SourceArn = "string",
    ReplyToEmailAddress = "string"
  ),
  SmsConfiguration = list(
    SnsCallerArn = "string",
    ExternalId = "string"
  ),
  UserPoolTags = list(
    "string"
  ),
  AdminCreateUserConfig = list(
    AllowAdminCreateUserOnly = TRUE|FALSE,
    UnusedAccountValidityDays = 123,
    InviteMessageTemplate = list(
      SMSMessage = "string",
      EmailMessage = "string",
      EmailSubject = "string"
    )
  ),
  UserPoolAddOns = list(
    AdvancedSecurityMode = "OFF"|"AUDIT"|"ENFORCED"
  )
)
}
}

\keyword{internal}
